function x = solveEquation( eqSym, ...
                              eqSymScalarParams, ...
                              eqSymArrParams, ...
                              eqSymScalarArgs, ...
                              eqSymArrArgs )
    arrParamsLen = length( eqSymArrParams );
    
    xSym = subs( eqSym, eqSymScalarParams, eqSymScalarArgs );
    
    if ~isempty( eqSymArrArgs )
        arrArgsLen = length( eqSymArrArgs( :, 1 ) );

        if length( xSym ) == 1
            xSym = repmat( xSym, arrArgsLen, 1 );
        end

        for varIdx = 1 : arrParamsLen
            for rowIdx = 1 : arrArgsLen
                xSym( rowIdx ) = subs( xSym( rowIdx ), ...
                                    eqSymArrParams( varIdx ), ...
                                    eqSymArrArgs( rowIdx, varIdx ) );
            end
        end
    end

    x = double( xSym );
end