function saveData( x, u_x, genName, measurement, loadType )
    columns = length( x( 1, : ) );
    
    varNames = strings( 1, 2 * columns );
    varData = cell( 1, 2 * columns );

    for idx = 1:columns
        varNames( 2 * idx - 1 ) = "x" + idx;
        varNames( 2 * idx ) = "u_x" + idx;

        varData{ 2 * idx - 1 } = x( :, idx );
        varData{ 2 * idx } = u_x( :, idx );
    end

    dataTable = table( varData{ : }, VariableNames = varNames );

    genResultsFolderPath = Constants.RESULTS_FILE_PATH + genName + "/";
    filePath = genResultsFolderPath + genName + loadType + measurement + "Data.txt";
    if ~isfolder( genResultsFolderPath )
        mkdir( genResultsFolderPath )
    end
    writetable( dataTable, filePath, "Delimiter", '\t' );
end