function fig = plotKvCurveComparison( KvVec, genNames )
    len = length( KvVec );
    V = linspace( 0, Constants.MAX_VOLTAGE, 100 );
    fig = figure;
    hold on
    xlabel( "Voltage, V (V)" )
    ylabel( "Rotational Speed, ω (RPM)" )
    title( "Kv Curve Comparison" )
    grid on
    grid minor
    for idx = 1 : len
        Kv = KvVec( idx );
        omega = Kv * V;
        genName = genNames( idx );
        plot( V, omega, "DisplayName", genName )
    end
    ylim( [ 0, Constants.MAX_SPEED ] )
    legend( "Location", "best" )
    hold off
end