function fig = initializePowerCurves( genName, constLoadType, constLoadVar, constLoadUnit )
    fig = figure;
    hold on
    grid on
    grid minor
    if constLoadType == "Resistance"
        angle = -135;
    else % Current
        angle = -45;
    end
    view( [ angle, 35.264 ] )
    titleStr = genName + ": Power vs Voltage vs " + constLoadType;
    title( titleStr )
    xlabel( "Voltage, V (V)" )
    ylabelStr = constLoadType + ", " + constLoadVar + " (" + constLoadUnit + ")";
    ylabel( ylabelStr )
    zlabel( "Power, P (W)" )
    hold off
end