function fig = initializeEfficiencyCurves( genName, constLoadType, constLoadVar, constLoadUnit )
    fig = figure;
    hold on
    grid on
    grid minor
    if constLoadType == "Resistance"
        angle = -135;
    else % Current
        angle = -45;
    end
    view( [ angle, 35.264 ] )
    titleStr = genName + ": Efficiency vs Rotational Speed vs " + constLoadType;
    title( titleStr )
    xlabel( "Rotational Speed, ω (RPM)" )
    ylabelStr = constLoadType + ", " + constLoadVar + " (" + constLoadUnit + ")";
    ylabel( ylabelStr )
    zlabel( "Efficiency, η (%)" )
    hold off
end