function handleNoLoadPostProcessing( genName, fileName )
    genNameNoSpace = strrep( genName, " ", "" );

    [ V, u_V, ~, ~, omega, u_omega, ~, ~ ] = getExpandedMeasurements( fileName );

    [ V, u_V ] = removeNoThrottleInputData( V, u_V, omega );
    [ omega, u_omega ] = removeNoThrottleInputData( omega, u_omega, omega );

%     KvCurveFig = initializeKvCurve( genName );
    KvCurveWithAvgDataFig = initializeKvCurve( genName );

    
    [ Kv, u_Kv ] = getKv( V, u_V, omega, u_omega );

    [ V_avg, u_V_avg ] = getWeightedAverageData( V, u_V );
    [ omegaAvg, u_omegaAvg ] = getWeightedAverageData( omega, u_omega );

%     KvCurveFig = plotKvCurve( KvCurveFig, V, u_V, omega, u_omega, Kv, u_Kv, genName );
    KvCurveWithAvgDataFig = plotKvCurve( KvCurveWithAvgDataFig, V_avg, u_V_avg, omegaAvg, u_omegaAvg, Kv, u_Kv, genName );

%     saveData( V, u_V, genNameNoSpace, "RawVoltage", "NoLoad" );
    saveData( V_avg, u_V_avg, genNameNoSpace, "Voltage", "NoLoad" );
%     saveData( omega, u_omega, genNameNoSpace, "RawSpeed", "NoLoad" );
    saveData( omegaAvg, u_omegaAvg, genNameNoSpace, "Speed", "NoLoad" );

%     fileName = genNameNoSpace + "KvCurve.png";
%     savePlot( KvCurveFig, genName, fileName );

    fileName = genNameNoSpace + "KvCurveWithAvgData.png";
    savePlot( KvCurveWithAvgDataFig, genName, fileName );
end