function [ mulitplier, u_multiplier ] = getVoltageDividerMultiplier()

    syms R1_sym R2_sym

    eqSym = ( R1_sym + R2_sym ) / R2_sym;

    eqSymScalarParams = [ R1_sym, R2_sym ]; 
    eqSymArrParams = []; 

    eqSymScalarArgs = [ Constants.RESISTANCE1, Constants.RESISTANCE2 ]; 
    eqSymArrArgs = []; 

    u_multiplier_R1 = getErrorPropagatedUncertainty( eqSym, ...
                                                     R1_sym, ...
                                                     Constants.RESISTANCE1_UNCERTAINTY, ...
                                                     eqSymScalarParams, ...
                                                     eqSymArrParams, ...
                                                     eqSymScalarArgs, ...
                                                     eqSymArrArgs );

    u_multiplier_R2 = getErrorPropagatedUncertainty( eqSym, ...
                                                     R2_sym, ...
                                                     Constants.RESISTANCE2_UNCERTAINTY, ...
                                                     eqSymScalarParams, ...
                                                     eqSymArrParams, ...
                                                     eqSymScalarArgs, ...
                                                     eqSymArrArgs );

    mulitplier = solveEquation( eqSym, ...
                                eqSymScalarParams, ...
                                eqSymArrParams, ...
                                eqSymScalarArgs, ...
                                eqSymArrArgs );
    u_multiplier = getTotalUncertainty( u_multiplier_R1, u_multiplier_R2 );
end