function [ V_uncal, u_V_uncal ] = getUncalibratedVoltage( adcCount )

    syms V_ref_sym adcCountSym bitsSym

    eqSym = V_ref_sym .* adcCountSym ./ 2.^bitsSym;

    eqSymScalarParams = [ V_ref_sym, bitsSym, ]; 
    eqSymArrParams = adcCountSym; 

    eqSymScalarArgs = [ Constants.REFERENCE_VOLTAGE, ...
                        Constants.NUM_OF_BITS ]; 
    eqSymArrArgs = adcCount;

    e_Q = getQuantizationError();

    u_V_uncal_V_ref = getErrorPropagatedUncertainty( eqSym, ...
                                                     V_ref_sym, ...
                                                     Constants.REFERENCE_VOLTAGE_UNCERTAINTY, ...
                                                     eqSymScalarParams, ...
                                                     eqSymArrParams, ...
                                                     eqSymScalarArgs, ...
                                                     eqSymArrArgs );

    V_uncal = solveEquation( eqSym, ...
                             eqSymScalarParams, ...
                             eqSymArrParams, ...
                             eqSymScalarArgs, ...
                             eqSymArrArgs );
    u_V_uncal = getTotalUncertainty( e_Q, u_V_uncal_V_ref );
end