function [ I_uncal, u_I_uncal ] = getUncalibratedCurrent( V, u_V )

    syms V_sym V_ref_sym sensitivitySym

    eq = ( V_sym - ( V_ref_sym / 2 ) ) / sensitivitySym;

    eqScalarParams = [ V_ref_sym, sensitivitySym ]; 
    eqArrParams = V_sym; 
    
    eqScalarArgs = [ Constants.REFERENCE_VOLTAGE, ...
                        Constants.CURRENT_SENSOR_SENSITIVITY ]; 
    eqArrArgs = V;

    u_I_uncal_V = getErrorPropagatedUncertainty( eq, ...
                                                V_sym, ...
                                                u_V, ...
                                                eqScalarParams, ...
                                                eqArrParams, ...
                                                eqScalarArgs, ...
                                                eqArrArgs );

    u_I_uncal_V_ref = getErrorPropagatedUncertainty( eq, ...
                                                     V_ref_sym, ...
                                                     Constants.REFERENCE_VOLTAGE_UNCERTAINTY, ...
                                                     eqScalarParams, ...
                                                     eqArrParams, ...
                                                     eqScalarArgs, ...
                                                     eqArrArgs );

    I_uncal = solveEquation( eq, ...
                             eqScalarParams, ...
                             eqArrParams, ...
                             eqScalarArgs, ...
                             eqArrArgs );

    u_I_uncal = getTotalUncertainty( u_I_uncal_V, ...
                                     u_I_uncal_V_ref );
end