function u = getTotalUncertainty( varargin )
    len = 1;
    idx = 1;
    arrFound = false;

    while idx <= nargin && ~arrFound
        if ~isscalar( varargin{ idx } )
            len = length( varargin{ idx } );
            arrFound = true;
        end
        idx = idx + 1;
    end

    sumSquares = zeros( len, 1 );

    for idx = 1 : nargin
        u = varargin{ idx };

        if isscalar( u )
            u = repmat( u, len, 1 );
        end

        sumSquares = sumSquares + u.^2;
    end

    u = sqrt( sumSquares );
end