function [ omega, u_omega ] = getSpeedByArduinoClock( omegaPrime )
    syms f_sym prescalerSym omegaPrimeSym
    
    eq = 60 * f_sym / ( prescalerSym * omegaPrimeSym );

    eqScalarParams = [ f_sym, prescalerSym ]; 
    eqArrParams = omegaPrimeSym;

    omegaPrime( omegaPrime == 0 ) = NaN;

    u_f = getArduinoClockFrequencyUncertainty();
    
    eqScalarArgs = [ Constants.ARDUINO_CLOCK_FREQUENCY, Constants.PRESCALER ]; 
    eqArrArgs = omegaPrime;

    u_omega_f = getErrorPropagatedUncertainty( eq, ...
                                               f_sym, ...
                                               u_f, ...
                                               eqScalarParams, ...
                                               eqArrParams, ...
                                               eqScalarArgs, ...
                                               eqArrArgs );

    omega = solveEquation( eq, ...
                           eqScalarParams, ...
                           eqArrParams, ...
                           eqScalarArgs, ...
                           eqArrArgs );
    omega( isnan( omega ) ) = 0;
    u_omega = u_omega_f;
    u_omega( isnan( u_omega ) ) = 0;
end