function [ R, u_R ] = getResistance( V, u_V, I, u_I )
    syms V_sym I_sym

    eq = V_sym / I_sym;

    eqScalarParams = [];
    eqArrParams = [ V_sym, I_sym ];

    eqScalarArgs = [];
    eqArrArgs = [ V, I ];

    u_R_V = getErrorPropagatedUncertainty( eq, ...
                                           V_sym, ...
                                           u_V, ...
                                           eqScalarParams, ...
                                           eqArrParams, ...
                                           eqScalarArgs, ...
                                           eqArrArgs );

    u_R_I = getErrorPropagatedUncertainty( eq, ...
                                           I_sym, ...
                                           u_I, ...
                                           eqScalarParams, ...
                                           eqArrParams, ...
                                           eqScalarArgs, ...
                                           eqArrArgs );

    R = solveEquation( eq, ...
                       eqScalarParams, ...
                       eqArrParams, ...
                       eqScalarArgs, ...
                       eqArrArgs );
    u_R = getTotalUncertainty( u_R_V, u_R_I );
end