function [ V_multiplied, u_V_multiplied ] = getMultipliedVoltage( V, u_V )
    syms V_sym multiplierSym

    eqSym = V_sym .* multiplierSym;

    eqSymScalarParams = multiplierSym; 
    eqSymArrParams = V_sym; 
    
    [ multiplier, u_multiplier ] = getVoltageDividerMultiplier();

    eqSymScalarArgs = multiplier;
    eqSymArrArgs = V;

    u_V_multiplied_V = getErrorPropagatedUncertainty( eqSym, ...
                                                        V_sym, ...
                                                        u_V, ...
                                                        eqSymScalarParams, ...
                                                        eqSymArrParams, ...
                                                        eqSymScalarArgs, ...
                                                        eqSymArrArgs );

    u_V_multiplied_multiplier = getErrorPropagatedUncertainty( eqSym, ...
                                                        multiplierSym, ...
                                                        u_multiplier, ...
                                                        eqSymScalarParams, ...
                                                        eqSymArrParams, ...
                                                        eqSymScalarArgs, ...
                                                        eqSymArrArgs );

    V_multiplied = solveEquation( eqSym, ...
                                  eqSymScalarParams, ...
                                  eqSymArrParams, ...
                                  eqSymScalarArgs, ...
                                  eqSymArrArgs );

    u_V_multiplied = getTotalUncertainty( u_V_multiplied_V, ...
                                          u_V_multiplied_multiplier );
end