function [ eta, u_eta ] = getEfficiency( P_m, u_P_m, P_e, u_P_e )
    syms P_m_sym P_e_sym

    eqSym = P_e_sym ./ P_m_sym .* 100;

    eqSymScalarParams = []; 
    eqSymArrParams = [ P_m_sym, P_e_sym ]; 
    eqSymScalarArgs = []; 
    eqSymArrArgs = [ P_m, P_e ]; 

    u_eta_P_m = getErrorPropagatedUncertainty( eqSym, ...
                                             P_m_sym, ...
                                             u_P_m, ...
                                             eqSymScalarParams, ...
                                             eqSymArrParams, ...
                                             eqSymScalarArgs, ...
                                             eqSymArrArgs );

    u_eta_P_e = getErrorPropagatedUncertainty( eqSym, ...
                                             P_e_sym, ...
                                             u_P_e, ...
                                             eqSymScalarParams, ...
                                             eqSymArrParams, ...
                                             eqSymScalarArgs, ...
                                             eqSymArrArgs );

    eta = solveEquation( eqSym, ...
                         eqSymScalarParams, ...
                         eqSymArrParams, ...
                         eqSymScalarArgs, ...
                         eqSymArrArgs );
    u_eta = getTotalUncertainty( u_eta_P_m, u_eta_P_e );
end