function [ constLoadVals, constLoadType, constLoadVar, constLoadUnit ] = getConstantLoadValues( fileName )

    constLoadVals = [];
    constLoadType = "";
    constLoadVar = "";
    constLoadUnit = "";
    
    sheetNames = sheetnames( fileName );
    sheetNamesLen = length( sheetNames );
    
    if contains( fileName, "Resistance" )
                constLoadType = "Resistance";
                constLoadVar = "R";
                constLoadUnit = "Ω"; % Supposed to be big omega symbol if
                                     % this character is corrupted
        
    elseif contains( fileName, "Current" )
        constLoadType = "Current";
        constLoadVar = "I";
        constLoadUnit = "A";
    end
    

    for idx = 1 : sheetNamesLen
        constMeasurement = sheetNames( idx ).split( " " );
        
        constVal = str2double( constMeasurement( 1 ) );

        if isnumeric( constVal )
            constLoadVals = [ constLoadVals, constVal ];
        end
    end
end