function getCalibrationResults()
    [ calVoltageFit, calVoltageSlope, calVoltageIntercept, calVoltageConfidenceInterval ] = getVoltageCalibrationResults();
    eqStr = printCalibrationEquation( calVoltageSlope, calVoltageIntercept, calVoltageConfidenceInterval, "V_{actual}", "V_{measured}" );
    plotCalibrationCurve( calVoltageFit, "Measured Voltage (V)", "Actual Voltage (V)", "Voltage", eqStr );
    
    [ calCurrentFit, calCurrentSlope, calCurrentIntercept, calCurrentConfidenceInterval ] = getCurrentCalibrationResults();
    eqStr = printCalibrationEquation( calCurrentSlope, calCurrentIntercept, calCurrentConfidenceInterval, "I_{actual}", "I_{measured}" );
    plotCalibrationCurve( calCurrentFit, "Measured Current (A)", "Actual Current (A)", "Current", eqStr );

    [ calTorqueFit, calTorqueSlope, calTorqueIntercept, calTorqueConfidenceInterval ] = getTorqueCalibrationResults();
    eqStr = printCalibrationEquation( calTorqueSlope, calTorqueIntercept, calTorqueConfidenceInterval, "T", "ADC Count" );
    plotCalibrationCurve( calTorqueFit, "ADC Count", "Actual Torque (N-mm)", "Torque", eqStr );
end