// Preprocessor directives
#ifndef VOLTAGE_DIVIDER_SENSOR_H
#define VOLTAGE_DIVIDER_SENSOR_H

// Header files
#include "Sensor.h"
#include "ArduinoUtilities.h"

// Constants
#define VOLTAGE_DIVIDER_HIGH_RESISTOR_KOHM 9.92
#define VOLTAGE_DIVIDER_LOW_RESISTOR_KOHM 0.995
#define VOLTAGE_DIVIDER_CALIBRATION_CURVE_SLOPE 1.0395
#define VOLTAGE_DIVIDER_CALIBRATION_CURVE_INTERCEPT -0.0374
#define VOLTAGE_DIVIDER_SAMPLE_AMT 1

class VoltageDividerSensor : public Sensor {
  public:
    VoltageDividerSensor( const int analogPin, 
                          const float resistance1, 
                          const float resistance2, 
                          const char *voltageUnit, 
                          const unsigned int num_of_samples,
                          const float calibrationCurveSlope,
                          const float calibrationCurveIntercept );

    void initialize() override;

    void measure() override;

  private:
    float multiplier;
    int aPin;
    float rawVoltage;
};

#endif // VOLTAGE_DIVIDER_SENSOR_H