// Header files
#include "VoltageDividerSensor.h"

VoltageDividerSensor::VoltageDividerSensor( const int analogPin, 
                                            const float resistance1,
                                            const float resistance2,
                                            const char *voltageUnit,
                                            const unsigned int num_of_samples,
                                            const float calibrationCurveSlope,
                                            const float calibrationCurveIntercept )
{
      aPin = analogPin;
      multiplier = ( resistance1 + resistance2 ) / resistance2;
      snprintf( unit, sizeof( unit ), "%s", voltageUnit );
      measurement = 0;
      digitalMeasurement = 0;
      
      sampleAmt = num_of_samples;
      calCurveSlope = calibrationCurveSlope;
      calCurveIntercept = calibrationCurveIntercept;
}


void VoltageDividerSensor::initialize()
{
  pinMode( aPin, INPUT );
}


void VoltageDividerSensor::measure()
{
  float voltageInputSum = 0;
  float calibratedVoltage;
  int digitalValSum = 0;
  int digitalVal;

  for ( int i = 0; i < sampleAmt; i++ )
  {
    voltageInputSum += getVoltage( aPin, &digitalVal );
    digitalValSum += digitalVal;
  }

  rawVoltage = voltageInputSum / sampleAmt;
  calibratedVoltage = calCurveSlope * rawVoltage + calCurveIntercept;


  measurement = calibratedVoltage * multiplier;
  digitalMeasurement = ( float ) digitalValSum / sampleAmt;
}