// Preprocessor directives
#ifndef LCD_SCREEN_H
#define LCD_SCREEN_H

// Header files
#include <LiquidCrystal_I2C.h>
#include "Sensor.h"
#include "StandardConstants.h"
#include "ControlConstants.h"

// Constants

  // Pins
  #define SD_CARD_READER_CS_PIN 10

  // Screen size
  #define COLUMNS 20
  #define ROWS 4

  // Other
  #define I2C_ADDRESS 0x27

class LcdScreen {
  public:
    LcdScreen( const int i2cAddress, const int numOfColumns, const int numOfRows );

    void initialize();

    void print( const char *string, const int line );

    void printUnit( const char *unit, const int line );

    void printValue( const float value, const int line );

    void clearChars( const int line, const int endingColumn = COLUMNS );

    void clearValue( const int line, const int unitLength );

    void clearChar();

    void clearScreen();

    void printMeasurement( const float measurement, const char *unit, const int line );

  private:
    LiquidCrystal_I2C screen;
    int cols;
    int rows;
};

#endif // LCD_SCREEN_H