// Header files
#include "CurrentSensor.h"

CurrentSensor::CurrentSensor( const int analogPin, 
                              const float sensitivity, 
                              const char *currentUnit, 
                              const unsigned int num_of_samples = 1,
                              const float calibrationCurveSlope = 1,
                              const float calibrationCurveIntercept = 0,
                              const float voltageCalibrationCurveSlope = 1,
                              const float voltageCalibrationCurveIntercept = 0 ) {
  aPin = analogPin;
  s = sensitivity;
  snprintf( unit, sizeof( unit ), "%s", currentUnit );
  sampleAmt = num_of_samples;
  measurement = 0;
  calCurveSlope = calibrationCurveSlope;
  calCurveIntercept = calibrationCurveIntercept;
  voltageCalCurveSlope = voltageCalibrationCurveSlope;
  voltageCalCurveIntercept = voltageCalibrationCurveIntercept;
}

void CurrentSensor::initialize()
{
  pinMode( aPin, INPUT );
}

void CurrentSensor::measure()
{

  // Initialize variables
  float voltageInSum = 0;
  int digitalValSum = 0;
  int digitalVal;
  float uncorrected_measurement;
  int sampleIdx;

  for ( sampleIdx = 0; sampleIdx < sampleAmt; sampleIdx++ )
  {
    voltageInSum += getVoltage( aPin, &digitalVal ); 
    digitalValSum += digitalVal;
  }
  
  rawCurrentVoltage = voltageCalCurveSlope * ( voltageInSum / sampleAmt ) + voltageCalCurveIntercept;
  digitalMeasurement = ( float ) digitalValSum / sampleAmt;
  uncorrected_measurement = ( rawCurrentVoltage - MIDPOINT_VOLTAGE ) / s;
  measurement = calCurveSlope * uncorrected_measurement + calCurveIntercept;
}
