// Preprocessor directives
#ifndef ARDUINO_UTILITIES_H
#define ARDUINO_UTILITIES_H

// Header files
#include "Arduino.h"

// Constants
#define REFERENCE_VOLTAGE 4.57 // Voltage from the 5V power supplied from the Arduino to the ground
#define MIDPOINT_VOLTAGE REFERENCE_VOLTAGE / 2.0
#define NUM_OF_BITS 10.0
#define RESOLUTION pow( 2, NUM_OF_BITS )
#define VOLTAGE_PER_DIGITAL_VALUE REFERENCE_VOLTAGE / RESOLUTION
#define CLOCK_FREQUENCY_MHZ 16000000.0
#define PRESCALER 256.0
#define COUNTS_PER_SECOND CLOCK_FREQUENCY_MHZ / PRESCALER
#define COUNTS_PER_MINUTE COUNTS_PER_SECOND * 60.0

enum ARDUINO_CODES {
  RESET = 4
};

float getAnalogVoltage( const int digitalVal );

float getSeconds();

float getVoltage( const int pinNumber, int *returnDigitalVal = NULL );

int getDigitalValue( const int analogPin );

#endif // ARDUINO_UTILITIES_H