'use strict';

var assert = require('chai').assert;
var proxyquire = require('proxyquire').noCallThru().noPreserveCache();

describe('socialCheckoutHelpers', function () {
    var socialCheckoutHelpers = proxyquire("../../../../../../social_checkout/cartridges/int_social_checkout/cartridge/scripts/util/socialCheckoutHelpers.js", {
    
        'dw/system/Logger': require('../../../../../mocks/dw/system/Logger'),
    
        'dw/order/LineItemCtnr': {
            'CHANNEL_TYPE_TIKTOK': 14
        }
    });

    it('Receive socialChannel as string and return channelType code', function () {
        var socialChannel = 'TikTok';
        var channelTypeNumber = socialCheckoutHelpers.getChannelType(socialChannel);
        assert.equal(channelTypeNumber, '14');
    });

    it('Receive socialChannel as code and return channelType code', function () {
        var socialChannel = '14';
        var channelTypeNumber = socialCheckoutHelpers.getChannelType(socialChannel);
        assert.equal(channelTypeNumber, '14');
    });

    it('Receive socialChannel as null and return null', function () {
        var socialChannel = null;
        var channelTypeNumber = socialCheckoutHelpers.getChannelType(socialChannel);
        assert.equal(channelTypeNumber, null);
    });

    it('socialChannel causes an error and return null', function () {
        var socialChannel = {};
        var channelTypeNumber = socialCheckoutHelpers.getChannelType(socialChannel);
        assert.equal(channelTypeNumber, null);
    });
});