var assert = require('chai').assert;
var expect = require('chai').expect

var proxyquire = require('proxyquire').noCallThru().noPreserveCache();
var Basket = require('../../../../../../mocks/Basket');
var Status = require('../../../../../../mocks/Status');
var Logger = require('../../../../../../mocks/dw/system/Logger');
var socialCheckoutHelpers = require('../../../../../../mocks/util/socialCheckoutHelpers');
var externalTaxesHelpers = require('../../../../../../mocks/util/externalTaxesHelpers');

describe('basket', function () {
    var basket = proxyquire("../../../../../../../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js", {
        'dw/system/Logger': Logger,
        'dw/system/Status': Status,
        '*/cartridge/scripts/util/socialCheckoutHelpers':  socialCheckoutHelpers,
        '*/cartridge/scripts/util/externalTaxesHelpers': externalTaxesHelpers,
        'dw.ocapi.shop.basket.afterPATCH':{}
    });

    it('afterPATCH: Applying the new tax value', function() {
        var objBasket = new Basket();
        var basketInput = {
            channel_type: 'channelType'
        };
        
        var testFn = basket.afterPATCH;        
        expect(function() { return testFn(objBasket, basketInput); }).not.to.Throw();
    });

    it('afterPATCH: Error - Try apply the new tax value sending a null as basket object', function() {
        var objBasket = null;
        var basketInput = {};

        var response = basket.afterPATCH(objBasket, basketInput);

        assert.equal(response.error, true);
        assert.equal(response.status, 1);
    });

    it('afterPATCH: Error - Try apply the new tax value sending a null as basketInput object', function() {
        var objBasket = new Basket();
        var basketInput = null;

        var response = basket.afterPATCH(objBasket, basketInput);

        assert.equal(response.error, true);
        assert.equal(response.status, 1);
    });

    it('afterPOST: Set the channel type', function() {
        var objBasket = new Basket();
        
        var testFn = basket.afterPOST;        
        expect(function() { return testFn(objBasket); }).not.to.Throw();
    });

    it('afterPOST: Error - Try to set channel type but basket object is a null', function() {
        var objBasket = null;

        var response = basket.afterPOST(objBasket);
        
        assert.equal(response.error, true);
        assert.equal(response.status, 1);
    });
});