var assert = require('chai').assert;
var SomAddressModel = require('../../../../../social_checkout/cartridges/int_order_som/cartridge/models/SomAddress.js');

var Address = {
    street: '996 Meadow View Drive',
    city: 'Hartford',
    state: 'Connecticut',
    postalCode: '06103'
};

var somAccount = {
    FirstName: "Wilson",
    LastName: "Fisk",
    Phone: "860-493-2247",
    PersonEmail: "kingpin@villain.com"
};


describe('SomAddress', function () {
    it('should receive a null somAccount and have to show blank information', function () {
        var result = new SomAddressModel(Address, null);
        assert.equal(result.firstName, '-');
        assert.equal(result.lastName, '-');
        assert.equal(result.phone, '-');
        assert.equal(result.email, '-');
    });

    it('should convert address and account data to an object', function () {
        var result = new SomAddressModel(Address, somAccount);
        assert.equal(result.firstName, 'Wilson');
        assert.equal(result.lastName, 'Fisk');
        assert.equal(result.phone, '860-493-2247');
        assert.equal(result.email, 'kingpin@villain.com');
        assert.equal(result.street, '996 Meadow View Drive');
        assert.equal(result.city, 'Hartford');
        assert.equal(result.state, 'Connecticut');
        assert.equal(result.postalCode, '06103');
    });
});
