'use strict';

const Assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();

var File = require('../../../../mocks/dw.io.File');
var Logger = require('../../../../mocks/dw/system/Logger');
var Site = require('../../../../mocks/dw/system/Site');
var LocalServiceRegistry = require('../../../../mocks/dw/svc/LocalServiceRegistry.js');

var HTTPRequestPart = require('../../../../mocks/dw.net.HTTPRequestPart');

describe('serviceHelper', function () {
    const serviceHelper = Proxy('../../../../../social_channels/cartridges/int_instagram/cartridge/scripts/services/serviceHelper.js', {
        '*/cartridge/scripts/social/helpers/serviceHelpers': {},
        'dw/util/ArrayList': {},
        'dw/net/HTTPRequestPart': HTTPRequestPart,
        'dw/svc/LocalServiceRegistry': LocalServiceRegistry,
        'dw/system/Logger': Logger,
        'dw/system/Site': Site
    });

    global.__proto__.empty = function () { return false; }
   
    it('It should get service', function () {
        global.request = {
            locale: {
                split: function () {
                    return ['','']
                }
            }
        }

        var getService = serviceHelper.getService('testservice');

        Assert.isObject(getService);
    });

    it('It should convert to multipart file', function () {
        var convertToMultiPartFile = serviceHelper.convertToMultiPartFile('', new File());
        Assert.isObject(convertToMultiPartFile);
    });

    it('It should convert to multipart param', function () {
        var convertToMultiPartParam = serviceHelper.convertToMultiPartParam('', '');
        Assert.isObject(convertToMultiPartParam);
    });
});