'use strict';

const assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();
const BasketMgr = require('../../../../../mocks/dw/order/BasketMgr');
const URLUtils = require('../../../../../mocks/dw/web/URLUtils');
const Resource = require('../../../../../mocks/dw/web/Resource');

const baseMyHelper = {};
Object.setPrototypeOf(module, Object.assign(Object.getPrototypeOf(module), {
    superModule: baseMyHelper

})); // module.__proto__.superModule can also be used but lint doesn't like it (see no-proto rule)

var discountLineItemsModel = Proxy('../../../../../../social_checkout/cartridges/int_google_tempbasket_addon/cartridge/models/productLineItem/decorators/discountBonusLineItems.js', {
    'dw/web/URLUtils': URLUtils,
    'dw/web/Resource': Resource,
    'dw/order/BasketMgr': BasketMgr,
    '*/cartridge/scripts/util/collections': {
        find: function(){ return {
            getBonusProductPrice: function(apiProduct) {
                return {
                    toFormattedString: function() {
                        return "2"
                    }
                }
            }
        }; },
        forEach: function(){
            
        }
    }
});

Object.__proto__.concat = function () { return false; }
global.__proto__.in ={}

describe('Discount Bonus Line Items for Google', function () {
    beforeEach(() => {
        global.request = {
            session:{
                    privacy: ['tempSocialBasket'],
                    tempSocialBasket: ['tempSocialBasket']
                }
            
        };
    });
    it('It should generates an object of URLs', function () {
        var result = discountLineItemsModel.discountLineItems({},'0000000000000001');
        assert.isUndefined(result);

    });
});