'use strict';

function getProduct (pid) {
    var getInventoryRecord;
    if (pid === 'noproduct') {
        getInventoryRecord = null;
    }
   
    return {
        getAvailabilityModel: function() {
            return {
                getInventoryRecord: function () {
                    if (!getInventoryRecord) {
                        return null;
                    }
                    return {};
                }
            }
        },
        getOptionModel() {
            return {
                getOptions() {
                    return {
                        iterator: function() {
                            let i = 0;
                            return {
                                items: [{
                                    defaultValue: 1000
                                }],
                                hasNext: function() {
                                    return i < this.items.length;
                                },
                                next: function() {
                                    return this.items[i++];
                                }
                            }
                        }
                    }
                }, 
                getPrice: function() {
                    return {
                        getValue: function() {
                            return 1000
                        }
                    }
                }
            }
        }
    };
}

module.exports = {
    getProduct: getProduct
}