import { test, expect, chromium, type Page } from '@playwright/test';

function delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

test.describe('Instagram Onboarding', () => {
    test('Try to setup Instagram Integration on Business Manager', async () => {
        const browser = await chromium.launch();
        const page = await browser.newPage();

        //Logging in to business manager
        await page.goto(process.env.BM_URL + '/on/demandware.store/Sites-Site');
        if (process.env.OKTA_LOGIN.toLowerCase() === "true") {
            await page.getByPlaceholder('User Name').click();
            await page.getByPlaceholder('User Name').fill(String(process.env.BM_USERNAME));
            await page.getByRole('button', { name: 'Log in' }).click();
            await page.getByRole('button', { name: 'Log in with SFDC Okta' }).click();
            await page.getByRole('textbox', { name: 'Username' }).click();
            await page.getByRole('textbox', { name: 'Username' }).fill(String(process.env.BM_USERNAME));
            await page.getByRole('button', { name: 'Next' }).click();
            await page.getByRole('textbox', { name: 'Password' }).fill(String(process.env.BM_PASSWORD));
            await page.getByRole('button', { name: 'Verify' }).click();
            await page.getByRole('link', { name: 'Select' }).nth(2).click();
        } else {
            await page.getByPlaceholder('User Name').click();
            await page.getByPlaceholder('User Name').fill(String(process.env.BM_USERNAME));
            await page.getByRole('button', { name: 'Log in' }).click();
            await page.getByPlaceholder('Password').click();
            await page.getByPlaceholder('Password').fill(String(process.env.BM_PASSWORD));
            await page.getByRole('button', { name: 'Log in' }).click();
        }
        await page.waitForURL(process.env.BM_URL + '/on/demandware.store/Sites-Site/default/ViewApplication-DisplayWelcomePage');
        console.log('Logged in on BM');
        await page.getByText(/Select a SiteSelect a /).click();
        await page.getByTitle(String(process.env.BM_SITE), { exact: true }).click();
        console.log('Select ' + process.env.BM_SITE + ' site');
        await page.getByRole('link', { name: 'Merchant Tools' }).click();
        console.log('Click on Merchant Tools');
        await page.getByRole('link').filter({ hasText: 'Social Channels Setup and Manage integrations with social channe' }).click();
        await page.getByRole('link').filter({ hasText: 'Facebook and Instagram' }).click();
        console.log('Click on Instagram Channel');
        page.getByRole('link').filter({ hasText: 'Accept Terms' }).click();
        await page.getByLabel('Short Code').click();
        await page.getByLabel('Short Code').fill(String(process.env.BM_SHORT_CODE));
        await page.getByLabel('Organization ID').click();
        await page.getByLabel('Organization ID').fill(String(process.env.BM_ORGANIZATION_ID));
        await delay(5000);
        await page.getByText(/Launch MBE/).click();
        console.log('Launch for MBE');
        const popupPromise = page.waitForEvent('popup');
        console.log('Showing Instagram site');
        const popup = await popupPromise;
        await popup.close();
        setTimeout(function () { page.close() }, 15000);
    });
});
