# End to End and Unit tests

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Get Started](#get-started)
  
</details>

## Overview
>Perfom E2E (End to End) funcionality testing of Social Channels integrations from start to finish and all unit tests related.

## Prerequisites
This requires that you have:
1. Install [Playwright](https://playwright.dev/docs/intro)

## Get Started
Just execute [e2e](../e2e) tests related with the integrations that you have installed in your environment.

There is a .env file with all environment variables that you need and set to do your tests.

```
BM_URL=''#e.g:https://abc123.dx.commercecloud.salesforce.com
BM_USERNAME=''
BM_PASSWORD=''
BM_SITE=''
BM_USERACCESSKEY=''
BM_SHORT_CODE=''
BM_ORGANIZATION_ID=''
ACCOUNTMANAGER_CLIENTID=''
ACCOUNTMANAGER_CLIENTSECRET=''
WEBDAV_CLIENTID=''
WEBDAV_CLIENTSECRET=''
OCAPI_VERSION=''
ACCESS_TOKEN=''
OCAPI_CLIENTID=''
OCAPI_CLIENTSECRET=''
SLAS_CLIENTID=''
SLAS_CLIENTSECRET=''
PARAM_INVENTORYLISTIDS=''
PARAM_FILENAMEPREFIX=''
PARAM_FEEDTYPEINVENTORY=''
PARAM_UPDATETYPEINVENTORY=''
PARAM_OVERWRITEEXPORTFILE=''
PARAM_FILENAMEORDEREXPORT=''
PARAM_FILEFOLDERORDEREXPORT=''
TIKTOK_EMAIL=''
TIKTOK_PHONE=''
GOOGLE_NAME=''
GOOGLE_EMAIL=''
GOOGLE_PHONE=''
GOOGLE_CLIENT_ID=''
GOOGLE_CLIENT_SECRET=''
GOOGLE_MERCHANT=''
GOOGLE_OCAPI_CLIENT_ID=''
GOOGLE_OCAPI_CLIENT_SECRET=''
GOOGLE_OCAPI_SITE=''
ORDER_PRODUCTID=''
ORDER_ID=''
PRODUCT_IDS_QTD_MOCK=''#e.g:701644043834M:1,029407331258M:2
ORDER_CURRENCYCODE=""
ORDER_EXTERNALORDERID=''
ORDER_SOM_INTEGRATION=''
INSTAGRAM_EMAIL=''
INSTAGRAM_OCAPI_CLIENT_ID=''
INSTAGRAM_OCAPI_CLIENT_SECRET=''
INSTAGRAM_OCAPI_SITE=''
SOCIAL_CHANNEL=''
OKTA_LOGIN='false'
```
Ensure that you obtain all credentials and keys before the tests

You can execute end to end test by command line:

>#### Run all the tests
> - ```npm run test:e2e```
>
>#### Run a single test file
> - ```npm run test:e2e <relative path>```\
>
>##### E.G:. ***```npm run test:e2e test/e2e/bm_socialchannels/BM_Google.spec.ts```***
>
>#### Run a set of test files
> - ```npm run test:e2e <relative path> <relative path>```\
>##### E.G:. ***```npm run test:e2e test/e2e/bm_socialchannels/BM_Google.spec.ts test/e2e/bm_socialchannels/BM_Instagram.spec.ts```***

To execute the [unit](../unit) tests you don't need the [Playwright](https://playwright.dev), just execute the command as follow ```npm run test``` 