@IsTest(SeeAllData=true) 
//Required due to the ConnectApi call, following the documentation guidance: https://developer.salesforce.com/docs/atlas.en-us.apexcode.meta/apexcode/connectAPI_TestingApex.htm
public class ReturnOrderTriggerHandlerTest {
	private static final SocialMockGenerator socialMockGenerator = new SocialMockGenerator();
    
	@IsTest
    public static void handleReturnRequestCanceledTest(){
        ConnectApi.ReturnOrderOutputRepresentation returnOrderOutputRepresentation = createDraftReturnOrder(1, 1);

        Test.startTest();
        
        Test.setMock(HttpCalloutMock.class, new OrderExportMockGenerator());
        
        ReturnOrder returnOrder = [SELECT Id, OrderSummaryId, Status 
                                   FROM ReturnOrder 
                                   WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];            
        Id returnOrderId = returnOrder.Id;
        
        List<ReturnOrderLineItem> returnOrderLineItens = [SELECT Id, Type, quantityExpected, ReturnOrderId, Product2Id 
                                                          FROM ReturnOrderLineItem 
                                                          WHERE ReturnOrderId =: returnOrderId];
       

        delete(returnOrderLineItens);
        
        ReturnOrder returnOrderToUpdate = [SELECT Id, Status, OrderSummaryId 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];
        returnOrderToUpdate.Status = 'Canceled';
        update returnOrderToUpdate;
        
        String returnOrderUpdatedStatus = [SELECT Status 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1].Status;
        system.assertNotEquals(returnOrderUpdatedStatus, returnOrder.Status, 'Returned status should be different.');
        
        Test.stopTest();
    }
    
    @IsTest
    public static void handleReturnRequestApprovedCompletedTest(){
        ConnectApi.ReturnOrderOutputRepresentation returnOrderOutputRepresentation = createDraftReturnOrder(1, 1);

        Test.startTest();
        
        Test.setMock(HttpCalloutMock.class, new OrderExportMockGenerator());
        
        ReturnOrder returnOrder = [SELECT Id, OrderSummaryId, Status 
                                   FROM ReturnOrder 
                                   WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];            
        Id returnOrderId = returnOrder.Id;
        
        List<ReturnOrderLineItem> returnOrderLineItens = [SELECT Id, Type, quantityExpected, ReturnOrderId, Product2Id 
                                                          FROM ReturnOrderLineItem 
                                                          WHERE ReturnOrderId =: returnOrderId];
       
        returnOrderLineItens[0].QuantityExpected = 1;
        returnOrderLineItens[1].QuantityExpected = 1;
        update(returnOrderLineItens);
        
        ReturnOrder returnOrderToUpdate = [SELECT Id, Status, OrderSummaryId 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];
        returnOrderToUpdate.Status = 'Approved';
        update returnOrderToUpdate;
        
        String returnOrderUpdatedStatus = [SELECT Status 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1].Status;
        system.assertNotEquals(returnOrderUpdatedStatus, returnOrder.Status, 'Returned status should be different.');
        
        Test.stopTest();
    }
    
    @IsTest
    public static void handleReturnRequestApprovedTest(){
        ConnectApi.ReturnOrderOutputRepresentation returnOrderOutputRepresentation = createDraftReturnOrder(1, 1);

        Test.startTest();
        
        Test.setMock(HttpCalloutMock.class, new OrderExportMockGenerator());
        
        ReturnOrder returnOrder = [SELECT Id, OrderSummaryId, Status 
                                   FROM ReturnOrder 
                                   WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];            
        Id returnOrderId = returnOrder.Id;
        
        List<ReturnOrderLineItem> returnOrderLineItens = [SELECT Id, Type, quantityExpected, ReturnOrderId, Product2Id 
                                                          FROM ReturnOrderLineItem 
                                                          WHERE ReturnOrderId =: returnOrderId];
       
        returnOrderLineItens[0].QuantityExpected = 1;
        update(returnOrderLineItens);
        
        ReturnOrder returnOrderToUpdate = [SELECT Id, Status, OrderSummaryId 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];
        returnOrderToUpdate.Status = 'Approved';
        update returnOrderToUpdate;
        
        String returnOrderUpdatedStatus = [SELECT Status 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1].Status;
        system.assertNotEquals(returnOrderUpdatedStatus, returnOrder.Status, 'Returned status should be different.');
        
        Test.stopTest();
    }
    
    @IsTest
    public static void handleReturnRequestClosedTest(){
        ConnectApi.ReturnOrderOutputRepresentation returnOrderOutputRepresentation = createDraftReturnOrder(1, 1);

        Test.startTest();
        
        Test.setMock(HttpCalloutMock.class, new OrderExportMockGenerator());
        
        ReturnOrder returnOrder = [SELECT Id, OrderSummaryId, Status 
                                   FROM ReturnOrder 
                                   WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];            
        Id returnOrderId = returnOrder.Id;
        
        List<ReturnOrderLineItem> returnOrderLineItens = [SELECT Id, Type, quantityExpected, ReturnOrderId 
                                                          FROM ReturnOrderLineItem 
                                                          WHERE ReturnOrderId =: returnOrderId];
        returnOrderLineItens[0].QuantityRejected = returnOrderLineItens[0].QuantityExpected;
        update(returnOrderLineItens);
        
        ReturnOrder returnOrderToUpdate = [SELECT Id, Status, OrderSummaryId 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1];
        returnOrderToUpdate.Status = 'Closed';
        update returnOrderToUpdate;
        
        String returnOrderUpdatedStatus = [SELECT Status 
                                           FROM ReturnOrder 
                                           WHERE Id =: returnOrderOutputRepresentation.returnOrderId LIMIT 1].Status;
        system.assertNotEquals(returnOrderUpdatedStatus, returnOrder.Status, 'Returned status should be different.');
        
        Test.stopTest();
    }
    
    public static ConnectApi.ReturnOrderOutputRepresentation createDraftReturnOrder(Decimal singleProductQuantity, Decimal returnQuantity){
        account newAccount = socialMockGenerator.generateAccount('Coffe Account');
        
        Product2 newProduct = socialMockGenerator.generateProduct('Coffe Machine', '1OsHr0000008ykkKAB');
        Product2 newProduct2 = socialMockGenerator.generateProduct('Coffe Machine 2', '1OsHr0000008ykkKAC');
		Product2 newProductFee = socialMockGenerator.generateProduct('Coffe Machine Fee', '1OsHr0000008ykkKAD');
        
        Pricebook2 newPricebook = socialMockGenerator.generatePricebook('Coffe Machine Pricebook', true);
        PricebookEntry[] newPricebookEntry = socialMockGenerator.generatePricebookEntry(newProduct, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntry2 = socialMockGenerator.generatePricebookEntry(newProduct2, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntryFee = socialMockGenerator.generatePricebookEntry(newProductFee, newPricebook, 1, 1, true);
        
        Order newOrder = socialMockGenerator.generateOrder('draft', newAccount, newPricebook);
        
        OrderDeliveryMethod newOrderDeliveryMethod = socialMockGenerator.generateOrderDeliveryMethod('Test ODM', true, '12342', newProduct);
        OrderDeliveryGroup newOrderDeliveryGroup = socialMockGenerator.generateOrderDeliveryGroup(newOrder, 
                                                                                                  'Coffe Delivery', 
                                                                                                  newOrderDeliveryMethod);

        OrderItem newOrderItem     = socialMockGenerator.generateOrderItem(newOrder, newProduct,
                                                                           newPricebookEntry, singleProductQuantity, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        OrderItem newOrderItem2    = socialMockGenerator.generateOrderItem(newOrder, newProduct2, 
                                                                           newPricebookEntry2, singleProductQuantity, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        
        socialMockGenerator.updateOrderStatus(newOrder, 'Activated');
        
        String orderSummaryId = socialMockGenerator.generateOrderSummary(newOrder, 'MANAGED');
        OrderSummary orderSummary = [SELECT FIELDS(STANDARD) 
                                     FROM OrderSummary 
                                     WHERE Id =: orderSummaryId LIMIT 1];
        
        String itemSummaryId     = [SELECT Id, Status 
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct.Id LIMIT 1].Id;
        String itemSummaryId2    = [SELECT Id, Status 
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct2.Id LIMIT 1].Id;

        List<ConnectApi.OrderItemSummaryInputRepresentation> orderItemSummaryInputRepresentationList = 
            new List<ConnectApi.OrderItemSummaryInputRepresentation>();
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId, 1);
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation2 = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId2, 1);
        
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation);
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation2);
        
        socialMockGenerator.generateFullfilmentOrder(orderSummaryId, newOrderDeliveryGroup.Id, orderItemSummaryInputRepresentationList);

        FulfillmentOrder fulfillmentOrder = [SELECT Status FROM FulfillmentOrder WHERE OrderSummaryId=: orderSummaryId LIMIT 1];
        fulfillmentOrder.Status = 'Fulfilled';
        update fulfillmentOrder;

        List<ConnectApi.ReturnOrderLineItemInputRepresentation> returnOrderLineItemInputRepresentationList = 
            new List<ConnectApi.ReturnOrderLineItemInputRepresentation>();
        returnOrderLineItemInputRepresentationList = socialMockGenerator.generateAndAddReturnOrderLineItemInput(
            returnOrderLineItemInputRepresentationList, false, itemSummaryId, returnQuantity, 'Unknown'
        );
        returnOrderLineItemInputRepresentationList = socialMockGenerator.generateAndAddReturnOrderLineItemInput(
            returnOrderLineItemInputRepresentationList, false, itemSummaryId2, returnQuantity, 'Unknown'
        );

        ConnectApi.ReturnOrderInputRepresentation returnOrderInputRepresentation = socialMockGenerator.generateReturnOrderInput(
            orderSummaryId, 'UNMANAGED', 'Submitted', returnOrderLineItemInputRepresentationList
        );
		ConnectApi.ReturnOrderOutputRepresentation returnOrderOutputRepresentation = socialMockGenerator.generateReturnOrder(
            returnOrderInputRepresentation
        );
        return returnOrderOutputRepresentation;
    }
}