@isTest
global class LineItemMockGenerator {
        public static final String CONTENT_TYPE = 'application/json';
        public static final String C_ORDER_ACTION = 'c_orderAction';
        public static final String PRODUCT_ITEMS = 'product_items';
        public static final String C_QUANTITY_RETURNED = 'c_quantityReturned';
        public static final String C_EXTERNAL_LINE_ITEM_RETURN_STATUS = 'c_externalLineItemReturnStatus';
        public static final String C_EXTERNAL_RETURN_STATUS = 'c_externalReturnStatus';
        public static final Integer QUANTITY_RETURNED_VALUE = 1;
        public static final Integer LINE_ITEM_RETURN_STATUS_VALUE = 8;
        public static final Integer EXTERNAL_RETURN_STATUS_PARTIAL = 9;
        public static final Integer EXTERNAL_RETURN_STATUS_FULL = 8;
        global class PartialReturn implements HttpCalloutMock {
        global HttpResponse respond(HTTPRequest req) {
            // Debug the incoming request body
            //System.debug('Request Body: ' + req.getBody());

            // Create an empty HTTPResponse
            HttpResponse res = new HttpResponse();
            res.setHeader('Content-Type', CONTENT_TYPE);

            String responseMessage = '{"example":"test"}';

            try{

                Map<String, Object> requestBody = (Map<String, Object>) JSON.deserializeUntyped(req.getBody());
                // Check if the action is "update"
                if (requestBody.containsKey(C_ORDER_ACTION) && requestBody.get(C_ORDER_ACTION) == 'update') {
                    if (requestBody.containsKey(PRODUCT_ITEMS)) {
                        List<Object> productItems = (List<Object>) requestBody.get(PRODUCT_ITEMS);
                        Boolean validRequest = false;
                        for (Object item : productItems) {
                            Map<String, Object> productItem = (Map<String, Object>) item;
                            if (productItem.containsKey(C_QUANTITY_RETURNED) && (Integer) productItem.get(C_QUANTITY_RETURNED) == QUANTITY_RETURNED_VALUE &&
                                productItem.containsKey(C_EXTERNAL_LINE_ITEM_RETURN_STATUS) &&  (Integer) productItem.get(C_EXTERNAL_LINE_ITEM_RETURN_STATUS) == EXTERNAL_RETURN_STATUS_FULL) {
                                    validRequest = true;
                                responseMessage = '{"status":"Success", "message":"Product with quantityReturned = 1 found"}';
                            }
                        }
                        if(!requestBody.containsKey(C_EXTERNAL_RETURN_STATUS)||(Integer) requestBody.get(C_EXTERNAL_RETURN_STATUS) != EXTERNAL_RETURN_STATUS_PARTIAL){
                            validRequest = false;
                        }
                        Assert.areEqual(validRequest, true,'either no quantityReturned != 1 or externalLineItemReturnStatus != 8 or c_externalReturnStatus != 9  ');
                    }
                    else {
                        Assert.fail('Product_items key not found');
                    }
                }
            }
            catch (Exception e){
            }

            // Set the response body and status code
            res.setBody(responseMessage);
            res.setStatusCode(200);
            return res;
        }
    }

    global class FullReturn implements HttpCalloutMock {
        global HttpResponse respond(HTTPRequest req) {
            // Debug the incoming request body
            //System.debug('Request Body: ' + req.getBody());

            // Create an empty HTTPResponse
            HttpResponse res = new HttpResponse();
            res.setHeader('Content-Type', 'application/json');

            String responseMessage = '{"example":"test"}';

            try{

            Map<String, Object> requestBody = (Map<String, Object>) JSON.deserializeUntyped(req.getBody());
            // Check if the action is "update"
            if (requestBody.containsKey(C_ORDER_ACTION) && requestBody.get(C_ORDER_ACTION) == 'update') {
                if (requestBody.containsKey('product_items')) {
                    List<Object> productItems = (List<Object>) requestBody.get(PRODUCT_ITEMS);
                    Boolean validRequest = false;
                    for (Object item : productItems) {
                        Map<String, Object> productItem = (Map<String, Object>) item;
                        if (productItem.containsKey(C_QUANTITY_RETURNED) && (Integer) productItem.get(C_QUANTITY_RETURNED) == QUANTITY_RETURNED_VALUE &&
                            productItem.containsKey(C_EXTERNAL_LINE_ITEM_RETURN_STATUS) &&  (Integer) productItem.get(C_EXTERNAL_LINE_ITEM_RETURN_STATUS) == LINE_ITEM_RETURN_STATUS_VALUE) {
                                validRequest = true;
                            responseMessage = '{"status":"Success", "message":"Product with quantityReturned = 1 found"}';
                        }
                    }
                    if(!requestBody.containsKey(C_EXTERNAL_RETURN_STATUS)||(Integer) requestBody.get(C_EXTERNAL_RETURN_STATUS) != EXTERNAL_RETURN_STATUS_FULL){
                        validRequest = false;
                    }
                    Assert.areEqual(validRequest, true,'either no quantityReturned != 1 or externalLineItemReturnStatus != 8 or c_externalReturnStatus != 8  ');
                }
                else {
                    Assert.fail('Product_items key not found');
                }
            }
            }
            catch (Exception e){
            }

            // Set the response body and status code
            res.setBody(responseMessage);
            res.setStatusCode(200);
            return res;
        }
    }
}

