@IsTest(SeeAllData=true)
public class ExportOrderSummaryItemTest{

    private static final SocialMockGenerator socialMockGenerator = new SocialMockGenerator();
    @isTest
    public static void testBlindPartialReturn() {
        String orderId = setupTestData();
        Test.startTest();
        HttpResponse mockResponse = new HttpResponse();
        mockResponse.setStatusCode(200);
        mockResponse.setBody('Success');
        Test.setMock(HttpCalloutMock.class, new LineItemMockGenerator.PartialReturn());
        
        
        List<Id> orderSummaryIds = new List<Id>{orderId};
        List<ExportOrderSummaryItem.OutputResource> results = ExportOrderSummaryItem.exportService(orderSummaryIds);
        List<OrderItemSummaryChange> orderItemSummaryChanges = new List<OrderItemSummaryChange>([Select Id, IsDeleted, OrderItemSummaryChangeNumber, CreatedDate, CreatedById,
        LastModifiedDate, LastModifiedById, SystemModstamp, OrderItemSummaryId, ChangeOrderItemId, OrderSummaryId,
        Reason, ChangeType, IsPreFulfillment, ReasonText, IsChangeSynced__c 
        from OrderItemSummaryChange 
        where OrderSummaryId IN: orderSummaryIds]);
        System.assertNotEquals(null, results);
        System.assertEquals(1, results.size());
        System.assertEquals('200', results[0].ErrorCode);
        
        Test.stopTest();
    }

    @isTest
    public static void testBlindFullReturn() {
        String orderId = setupTestDataFullReturn();
        Test.startTest();
        HttpResponse mockResponse = new HttpResponse();
        mockResponse.setStatusCode(200);
        mockResponse.setBody('Success');
        Test.setMock(HttpCalloutMock.class, new LineItemMockGenerator.FullReturn());
        
        
        List<Id> orderSummaryIds = new List<Id>{orderId};
        
        // Call the exportService method
        List<ExportOrderSummaryItem.OutputResource> results = ExportOrderSummaryItem.exportService(orderSummaryIds);
        List<OrderItemSummaryChange> orderItemSummaryChanges = new List<OrderItemSummaryChange>([Select Id, IsDeleted, OrderItemSummaryChangeNumber, CreatedDate, CreatedById,
        LastModifiedDate, LastModifiedById, SystemModstamp, OrderItemSummaryId, ChangeOrderItemId, OrderSummaryId,
        Reason, ChangeType, IsPreFulfillment, ReasonText, IsChangeSynced__c 
        from OrderItemSummaryChange 
        where OrderSummaryId IN: orderSummaryIds]);
        // Verify the output
        System.assertNotEquals(null, results);
        System.assertEquals(1, results.size());
        System.assertEquals('200', results[0].ErrorCode);
        
        Test.stopTest();
    }

    public static String setupTestData(){
        account newAccount = socialMockGenerator.generateAccount('Coffe Account');
        
        Product2 newProduct = socialMockGenerator.generateProduct('Coffe Machine', '1OsHr0000008ykkKAB');
        Product2 newProduct2 = socialMockGenerator.generateProduct('Coffe Machine 2', '1OsHr0000008ykkKAC');
		Product2 newProductFee = socialMockGenerator.generateProduct('Coffe Machine Fee', '1OsHr0000008ykkKAD');
        
        Pricebook2 newPricebook = socialMockGenerator.generatePricebook('Coffe Machine Pricebook', true);
        PricebookEntry[] newPricebookEntry = socialMockGenerator.generatePricebookEntry(newProduct, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntry2 = socialMockGenerator.generatePricebookEntry(newProduct2, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntryFee = socialMockGenerator.generatePricebookEntry(newProductFee, newPricebook, 1, 1, true);
        
        Order newOrder = socialMockGenerator.generateOrder('draft', newAccount, newPricebook);
        
        OrderDeliveryMethod newOrderDeliveryMethod = socialMockGenerator.generateOrderDeliveryMethod('Test ODM', true, '12342', newProduct);
        OrderDeliveryGroup newOrderDeliveryGroup = socialMockGenerator.generateOrderDeliveryGroup(newOrder, 
                                                                                                  'Coffe Delivery', 
                                                                                                  newOrderDeliveryMethod);

        OrderItem newOrderItem     = socialMockGenerator.generateOrderItem(newOrder, newProduct,
                                                                           newPricebookEntry, 1, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        OrderItem newOrderItem2    = socialMockGenerator.generateOrderItem(newOrder, newProduct2, 
                                                                           newPricebookEntry2, 1, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        
        socialMockGenerator.updateOrderStatus(newOrder, 'Activated');
        
        String orderSummaryId = socialMockGenerator.generateOrderSummary(newOrder, 'MANAGED');
        OrderSummary orderSummary = [SELECT FIELDS(STANDARD) 
                                     FROM OrderSummary 
                                     WHERE Id =: orderSummaryId LIMIT 1];
        
        String itemSummaryId     = [SELECT Id, Status
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct.Id LIMIT 1].Id;
        String itemSummaryId2    = [SELECT Id, Status 
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct2.Id LIMIT 1].Id;

        List<ConnectApi.OrderItemSummaryInputRepresentation> orderItemSummaryInputRepresentationList = 
            new List<ConnectApi.OrderItemSummaryInputRepresentation>();
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId, 1);
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation2 = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId2, 1);
        
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation);
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation2);
        
        socialMockGenerator.generateFullfilmentOrder(orderSummaryId, newOrderDeliveryGroup.Id, orderItemSummaryInputRepresentationList);

        FulfillmentOrder fulfillmentOrder = [SELECT Status FROM FulfillmentOrder WHERE OrderSummaryId=: orderSummaryId LIMIT 1];
        fulfillmentOrder.Status = 'Fulfilled';
        update fulfillmentOrder;
        ConnectApi.ChangeItemInputRepresentation returnLineChangeItem = socialMockGenerator.createReturnLineChangeItem(itemSummaryId,1,'IG_SUPPORT','The product arrived damaged and needs to be returned');
        socialMockGenerator.createReturnFromLineChangeItems(orderSummaryId, new List<ConnectApi.ChangeItemInputRepresentation>{returnLineChangeItem});
        return orderSummaryId;
    }

    public static String setupTestDataFullReturn(){
        account newAccount = socialMockGenerator.generateAccount('Coffe Account');
        
        Product2 newProduct = socialMockGenerator.generateProduct('Coffe Machine', '1OsHr0000008ykkKAB');
        Product2 newProduct2 = socialMockGenerator.generateProduct('Coffe Machine 2', '1OsHr0000008ykkKAC');
		Product2 newProductFee = socialMockGenerator.generateProduct('Coffe Machine Fee', '1OsHr0000008ykkKAD');
        
        Pricebook2 newPricebook = socialMockGenerator.generatePricebook('Coffe Machine Pricebook', true);
        PricebookEntry[] newPricebookEntry = socialMockGenerator.generatePricebookEntry(newProduct, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntry2 = socialMockGenerator.generatePricebookEntry(newProduct2, newPricebook, 50, 50, true);
        PricebookEntry[] newPricebookEntryFee = socialMockGenerator.generatePricebookEntry(newProductFee, newPricebook, 1, 1, true);
        
        Order newOrder = socialMockGenerator.generateOrder('draft', newAccount, newPricebook);
        
        OrderDeliveryMethod newOrderDeliveryMethod = socialMockGenerator.generateOrderDeliveryMethod('Test ODM', true, '12342', newProduct);
        OrderDeliveryGroup newOrderDeliveryGroup = socialMockGenerator.generateOrderDeliveryGroup(newOrder, 
                                                                                                  'Coffe Delivery', 
                                                                                                  newOrderDeliveryMethod);

        OrderItem newOrderItem     = socialMockGenerator.generateOrderItem(newOrder, newProduct,
                                                                           newPricebookEntry, 1, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        OrderItem newOrderItem2    = socialMockGenerator.generateOrderItem(newOrder, newProduct2, 
                                                                           newPricebookEntry2, 1, 10, 
                                                                           newOrderDeliveryGroup, 'Order Product');
        
        socialMockGenerator.updateOrderStatus(newOrder, 'Activated');
        
        String orderSummaryId = socialMockGenerator.generateOrderSummary(newOrder, 'MANAGED');
        OrderSummary orderSummary = [SELECT FIELDS(STANDARD) 
                                     FROM OrderSummary 
                                     WHERE Id =: orderSummaryId LIMIT 1];
        
        String itemSummaryId     = [SELECT Id, Status
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct.Id LIMIT 1].Id;
        String itemSummaryId2    = [SELECT Id, Status 
                                    FROM OrderItemSummary 
                                    WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct2.Id LIMIT 1].Id;

        List<ConnectApi.OrderItemSummaryInputRepresentation> orderItemSummaryInputRepresentationList = 
            new List<ConnectApi.OrderItemSummaryInputRepresentation>();
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId, 1);
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation2 = 
            socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId2, 1);
        
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation);
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation2);
        
        socialMockGenerator.generateFullfilmentOrder(orderSummaryId, newOrderDeliveryGroup.Id, orderItemSummaryInputRepresentationList);

        FulfillmentOrder fulfillmentOrder = [SELECT Status FROM FulfillmentOrder WHERE OrderSummaryId=: orderSummaryId LIMIT 1];
        fulfillmentOrder.Status = 'Fulfilled';
        update fulfillmentOrder;
        ConnectApi.ChangeItemInputRepresentation returnLineChangeItem = socialMockGenerator.createReturnLineChangeItem(itemSummaryId,1,'IG_SUPPORT','The product arrived damaged and needs to be returned');
        ConnectApi.ChangeItemInputRepresentation returnLineChangeItem2 = socialMockGenerator.createReturnLineChangeItem(itemSummaryId2,1,'IG_SUPPORT','The product arrived damaged and needs to be returned');
        socialMockGenerator.createReturnFromLineChangeItems(orderSummaryId, new List<ConnectApi.ChangeItemInputRepresentation>{returnLineChangeItem,returnLineChangeItem2});
        return orderSummaryId;
    }

   
}