public class ExportOrderSummaryItem {


    private static final String CANCEL = 'Cancel';
    private static final String PRODUCT = 'ProductAdjustment';
    private static final String SHIPPING = 'DeliveryChargeAdjustment';
    private static final String RETURN_TYPE = 'Return';
    private static final String ORDER_LINE_ITEM_TYPE_DELIVERY = 'Delivery Charge';
    private static final String ORDER_LINE_ITEM_TYPE_PRODUCT = 'Order Product';


    private static final List<String> CHANGE_TYPE = new List<String>{CANCEL, PRODUCT, SHIPPING, RETURN_TYPE};

    private static final Map<String, Integer> refundStatus = new Map<String, Integer>{
        'REFUNDED' => 8,
        'PARTIAL_REFUNDED' => 9
    };

    private static final String ORDER_ACTION = 'update';

    @InvocableMethod(label='Export OrderItemSummary on Change' description='Service to export Order Item Summary Change to external system')
    public static List<OutputResource> exportService(List<Id> orderSummaryIds){
        ExportOrderSummaryItem exportOrderSummaryItem = new ExportOrderSummaryItem();
       List<OutputResource> outputResource = exportOrderSummaryItem.processData(orderSummaryIds);
	   return outputResource;
    }

    public List<OutputResource> processData(List<Id> orderSummaryIds){
        OrderStatusExportAuthHelper authHelper = new OrderStatusExportAuthHelper();
        Order_Status_Update_Params__mdt params = new Order_Status_Update_Params__mdt();
        HttpResponse res = new HttpResponse();
        List<OutputResource> outputResList = new List<OutputResource>();
        if(orderSummaryIds.size() > 0) {
            params = authHelper.getOAuthConnInfo();
            String token = authHelper.getOAuthToken(params);
            Map<ID, OrderSummary> orderSummaries = getOrderSummary(orderSummaryIds);
            Map<ID, OrderItemSummaryChange> orderItemSumChangesMap = getOrderItemSummaryChanges(orderSummaryIds);
            List<Id> orderItemSummaryIds = getOrderItemSummaryIds(orderItemSumChangesMap);
            List<Id> orderItemSummaryChangeIds = getOrderItemSummaryChangeIds(orderItemSumChangesMap);
            Map<ID, OrderItem> orderItems = getOrderItems(orderItemSummaryChangeIds);

            Map<ID, List<OrderItemSummaryChange>> orderItemSumChangesListMap = getOrderItemSummaryChangeListMap(orderSummaries, orderItemSumChangesMap);
            Map<ID, OrderItemSummary> orderItemSummaryMap = getOrderItemSummaryMap(orderItemSummaryIds);
  		    List<Order_Export_Line_Status_Map__c> statusMap = [select id,OMS_Status__c,Export_Status__c from Order_Export_Line_Status_Map__c];
            for(String orderSummaryId : orderSummaryIds){

                OrderSummary orderSummary = orderSummaries.get(orderSummaryId);
                List<OrderItemSummaryChange> orderItemSumChanges = orderItemSumChangesListMap.get(orderSummaryId);
                if(orderItemSumChanges.size() > 0){
                    String payload = getPayload(orderSummary, orderItemSumChanges, orderItemSummaryMap, statusMap, orderItems);
                    res = authHelper.sendOrderUpdate(params,token,orderSummary.OrderNumber,payload);

                    OutputResource response = new OutputResource();

                    response.ErrorCode= String.valueof(res.getStatusCode());
                    response.ErrorMsg = res.getStatus();
                    outputResList.add(response);
                }
            }
            updateOrdItemSumChanges(orderItemSumChangesListMap);
        }

        return outputResList;
    }

    public void updateOrdItemSumChanges(Map<ID, List<OrderItemSummaryChange>> orderItemSumChangesListMap){
        List<OrderItemSummaryChange> ordItemSumChangesListToDelete = new List<OrderItemSummaryChange>();
        List<OrderItemSummaryChange> ordItemSumChangesListToAdd = new List<OrderItemSummaryChange>();
        for(Id orderItemSumChangesListId: orderItemSumChangesListMap.keySet()){
            List<OrderItemSummaryChange> orderItemSumChangesList = orderItemSumChangesListMap.get(orderItemSumChangesListId);
            for(OrderItemSummaryChange ordItemSumChange : orderItemSumChangesList){
                if(ordItemSumChange.ChangeType == CANCEL){
                    ordItemSumChangesListToDelete.add(ordItemSumChange);
                }
                else {
                    if(ordItemSumChange.ChangeType == PRODUCT){
                        ordItemSumChangesListToDelete.add(ordItemSumChange);
                    }
                }
            }
        }
        delete ordItemSumChangesListToDelete;

        for(OrderItemSummaryChange ordItemSumChange : ordItemSumChangesListToDelete){
            ordItemSumChange.Id = null;
            ordItemSumChange.IsChangeSynced__c = true;
            ordItemSumChangesListToAdd.add(ordItemSumChange);
        }
        insert ordItemSumChangesListToAdd;
    }

    public String getPayload(OrderSummary orderSummary, List<OrderItemSummaryChange> ordItemSumChanges, Map<ID, OrderItemSummary> orderItemSummaryMap, List<Order_Export_Line_Status_Map__c> statusMap, Map<ID, OrderItem> orderItems){
        List<String> providerList = new List<String>();
        Map<String, String> carrierMap = new Map<String, String>();
        String payload='';
        Boolean isReturnChangeType = false;
        JSONGenerator gen = JSON.createGenerator(true);
        gen.writeStartObject();
            gen.writeStringField('c_orderAction', ORDER_ACTION);
            gen.writeFieldName('product_items');
            gen.writeStartArray();
                for(OrderItemSummaryChange ordItemSumChange : ordItemSumChanges){
                    if(ordItemSumChange.ChangeType == CANCEL){
                        OrderItemSummary orderItemSummary = orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId);
                        gen.writeStartObject();
                            gen.writeStringField('product_id', orderItemSummary.ProductCode);
                            gen.writeNumberField('c_quantityCanceled', orderItemSummary.QuantityCanceled);
                            gen.writeNumberField('c_externalLineItemStatus', Integer.valueOf(getOrderLineStatus(statusMap, orderItemSummary.Status)));
                            gen.writeStringField('c_reason', ordItemSumChange.Reason);
                            gen.writeStringField('c_changeId', ordItemSumChange.Id);
                        gen.writeEndObject();
                    }
                    else if(ordItemSumChange.ChangeType == PRODUCT){

                        OrderItem orderItem = orderItems.get(ordItemSumChange.ChangeOrderItemId);

                        OrderItemSummary orderItemSummary = orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId);
                        gen.writeStartObject();
                            gen.writeStringField('product_id', orderItemSummary.ProductCode);
                            gen.writeStringField('c_reason', ordItemSumChange.Reason);
                            gen.writeStringField('c_changeId', ordItemSumChange.Id);
                            gen.writeNumberField('c_productDiscount', orderItem.TotalAdjustmentAmount);
                            gen.writeNumberField('c_taxDiscount', orderItem.TotalAdjustmentTaxAmount);

                            if(orderItemSummary.AdjustedLineAmount == 0){
                                gen.writeNumberField('c_externalLineItemStatus', refundStatus.get('REFUNDED'));
                            } else {
                                gen.writeNumberField('c_externalLineItemStatus', refundStatus.get('PARTIAL_REFUNDED'));
                            }

                        gen.writeEndObject();
                    }
                    else if(ordItemSumChange.ChangeType == RETURN_TYPE && orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId).Type == ORDER_LINE_ITEM_TYPE_PRODUCT){
                        isReturnChangeType = true;
                        OrderItem orderItem = orderItems.get(ordItemSumChange.ChangeOrderItemId);

                        OrderItemSummary orderItemSummary = orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId);
                        gen.writeStartObject();
                            gen.writeStringField('product_id', orderItemSummary.ProductCode);
                            gen.writeStringField('c_reason', ordItemSumChange.Reason);
                            gen.writeStringField('c_changeId', ordItemSumChange.Id);
                            gen.writeNumberField('c_quantityReturned',orderItemSummary.QuantityReturned);
                            if(orderItemSummary.QuantityReturned == orderItemSummary.QuantityFulfilled){
                                gen.writeNumberField('c_externalLineItemReturnStatus', refundStatus.get('REFUNDED'));
                            } else {
                                gen.writeNumberField('c_externalLineItemReturnStatus', refundStatus.get('PARTIAL_REFUNDED'));
                            }

                        gen.writeEndObject();
                    }
                }
            gen.writeEndArray();
            if(isReturnChangeType){
                Boolean isReturnEntireOrder = true;
                List<OrderItemSummary> orderlineItemSummary = [
                                 SELECT Id, QuantityFulfilled, QuantityReturned, QuantityCanceled, QuantityOrdered, ProductCode,
                                 Status, AdjustedLineAmount, OrderDeliveryGroupSummaryId  FROM OrderItemSummary
                                 WHERE OrderSummaryId = :orderSummary.Id];
                for (OrderItemSummary item : orderlineItemSummary) {
                    if(item.QuantityReturned != item.QuantityFulfilled){
                        isReturnEntireOrder = false;
                    }
                }
                if(isReturnEntireOrder){
                    gen.writeNumberField('c_externalReturnStatus', refundStatus.get('REFUNDED'));
                } else {
                    gen.writeNumberField('c_externalReturnStatus', refundStatus.get('PARTIAL_REFUNDED'));
                }
            }

            gen.writeFieldName('shipping_items');
            gen.writeStartArray();
                for(OrderItemSummaryChange ordItemSumChange : ordItemSumChanges){
                    if(ordItemSumChange.ChangeType == SHIPPING ){

                        OrderItem orderItem = orderItems.get(ordItemSumChange.ChangeOrderItemId);
                        OrderItemSummary orderItemSummary = orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId);
                        gen.writeStartObject();
                            gen.writeStringField('c_reason', ordItemSumChange.Reason);
                            gen.writeNumberField('c_shippingDiscount', orderItem.TotalAdjustmentAmount);
                            gen.writeNumberField('c_taxDiscount', orderItem.TotalAdjustmentTaxAmount);
                            gen.writeStringField('c_changeId', ordItemSumChange.Id);

                            if(orderItemSummary.AdjustedLineAmount == 0){
                                gen.writeNumberField('c_externalLineItemStatus', refundStatus.get('REFUNDED'));
                            } else {
                                gen.writeNumberField('c_externalLineItemStatus', refundStatus.get('PARTIAL_REFUNDED'));
                            }

                        gen.writeEndObject();
                    }
                    //for shipping change type showing as return
                    else if (ordItemSumChange.ChangeType == RETURN_TYPE && 
                            orderItemSummaryMap.containsKey(ordItemSumChange.OrderItemSummaryId) &&
                            orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId).Type == ORDER_LINE_ITEM_TYPE_DELIVERY ){

                        OrderItem orderItem = orderItems.get(ordItemSumChange.ChangeOrderItemId);
                        OrderItemSummary orderItemSummary = orderItemSummaryMap.get(ordItemSumChange.OrderItemSummaryId);
                        gen.writeStartObject();
                            gen.writeStringField('c_reason', ordItemSumChange.Reason);
                            gen.writeNumberField('c_shippingDiscount', orderItem.TotalLineAmount);
                            gen.writeNumberField('c_taxDiscount', orderItem.TotalTaxAmount);
                            gen.writeStringField('c_changeId', ordItemSumChange.Id);
                            gen.writeNumberField('c_externalLineItemStatus', refundStatus.get('REFUNDED'));

                        gen.writeEndObject();
                    }
                }
            gen.writeEndArray();

        gen.writeEndObject();
        payload = gen.getAsString();

        return payload;
    }

    public Map<ID, List<OrderItemSummaryChange>> getOrderItemSummaryChangeListMap(Map<ID, OrderSummary> orderSummaries, Map<ID, OrderItemSummaryChange> orderItemSummaryChangeMap){
        Map<ID, List<OrderItemSummaryChange>> orderItemSummaryChangeListMap = new Map<ID, List<OrderItemSummaryChange>>();
        for(ID orderSummaryId : orderSummaries.keySet()){
            List<OrderItemSummaryChange> orderItemSummaryChangeList = new List<OrderItemSummaryChange>();
            for(ID orderItemSummaryChangeId : orderItemSummaryChangeMap.keySet()){
                OrderItemSummaryChange orderItemSummaryChange = orderItemSummaryChangeMap.get(orderItemSummaryChangeId);
                if (orderSummaryId == orderItemSummaryChange.OrderSummaryId){
                    orderItemSummaryChangeList.add(orderItemSummaryChange);
                }
            }
            orderItemSummaryChangeListMap.put(orderSummaryId, orderItemSummaryChangeList);
        }
        return orderItemSummaryChangeListMap;
    }

    public List<Id> getOrderItemSummaryIds(Map<ID, OrderItemSummaryChange> orderItemSummaryChanges){
        List<Id> orderItemSummaryIds = new List<Id>();
        for(ID orderItemSummaryChangeId: orderItemSummaryChanges.keySet()){
            OrderItemSummaryChange orderItemSummaryChange = orderItemSummaryChanges.get(orderItemSummaryChangeId);
            orderItemSummaryIds.add(orderItemSummaryChange.OrderItemSummaryId);
        }
        return orderItemSummaryIds;
    }


    public List<Id> getOrderItemSummaryChangeIds(Map<ID, OrderItemSummaryChange> orderItemSummaryChanges){
        List<Id> orderItemSummaryChangeIds = new List<Id>();
        for(ID orderItemSummaryChangeId: orderItemSummaryChanges.keySet()){
            OrderItemSummaryChange orderItemSummaryChange = orderItemSummaryChanges.get(orderItemSummaryChangeId);
            orderItemSummaryChangeIds.add(orderItemSummaryChange.ChangeOrderItemId);
        }
        return orderItemSummaryChangeIds;
    }


    public Map<ID, OrderSummary> getOrderSummary(List<String> orderSummaryId){
        Map<ID, OrderSummary> ordSummaries = new Map<ID, OrderSummary>([Select id, OrderNumber, Status from OrderSummary where id IN: orderSummaryId]);

        return ordSummaries;
    }

    public Map<ID, OrderItemSummary> getOrderItemSummaryMap(List<String> orderItemSummaryIds){
        Map<ID, OrderItemSummary> orderItemSummary = new Map<ID, OrderItemSummary>([Select Id, QuantityFulfilled, QuantityReturned, QuantityCanceled, QuantityOrdered, ProductCode, Status, AdjustedLineAmount, OrderDeliveryGroupSummaryId, Type from OrderItemSummary where Id IN: orderItemSummaryIds]);

        return orderItemSummary;
    }

    public Map<ID, OrderItemSummaryChange> getOrderItemSummaryChanges(List<String> orderSummaryIds){
        Map<ID, OrderItemSummaryChange> orderItemSummaryChanges = new Map<ID, OrderItemSummaryChange>([Select Id, IsDeleted, OrderItemSummaryChangeNumber, CreatedDate, CreatedById,
                                                                LastModifiedDate, LastModifiedById, SystemModstamp, OrderItemSummaryId, ChangeOrderItemId, OrderSummaryId,
                                                                Reason, ChangeType, IsPreFulfillment, ReasonText, IsChangeSynced__c
                                                                from OrderItemSummaryChange
                                                                where OrderSummaryId IN: orderSummaryIds and
                                                                ChangeType IN: CHANGE_TYPE and
                                                                IsChangeSynced__c =: false]);

        return orderItemSummaryChanges;
    }

    public Map<ID, OrderItem> getOrderItems(List<String> orderItemSummaryChangesIds){
        Map<ID, OrderItem> orderItemSummaryChanges = new Map<ID, OrderItem>([SELECT Id, TotalAdjustmentAmount, TotalAdjustmentTaxAmount,TotalLineAmount, TotalTaxAmount, Type FROM OrderItem
                                                                where Id IN: orderItemSummaryChangesIds]);

        return orderItemSummaryChanges;
    }

    //Get Order Line Status Mapping
     public String getOrderLineStatus(List<Order_Export_Line_Status_Map__c> statusMaps, String status) {
        String orderStatus='0';

        for(Order_Export_Line_Status_Map__c statusMap: statusMaps){
            if(statusMap.OMS_Status__c == status){
                orderStatus = statusMap.Export_Status__c;
            }
        }

        return orderStatus;
    }

    public class OutputResponse{
        public integer HTTPStatusCode;
        public string HTTPStatusRes;
    }

    public class OutputResource{
        @InvocableVariable(Label='Error Code')
        public String ErrorCode;

        @InvocableVariable(Label='Error Message')
        public String ErrorMsg;
    }

    public class CustomException extends Exception {

    }
}
