'use strict';

var Money = require('dw/value/Money');

/**
 * add order restocking fee price adjustment
 * @param {dw.order.Basket} order - current basket
 * @param {number} restockingFee - amount
 * */
function updateOrderWithRestockingFee(order, restockingFee) {
    if (order) {
        var currencyCode = order.getCurrencyCode();
        var basketRestockingFee = order.createPriceAdjustment('restockingfee_' + (new Date()).toISOString());
        basketRestockingFee.setPriceValue(restockingFee);
        var basketTaxRate = 0;
        var basketTaxAmount = new Money(0, currencyCode);
        basketRestockingFee.setTax(basketTaxAmount);
        basketRestockingFee.updateTax(basketTaxRate * 1.0);
        basketRestockingFee.updateTaxAmount(basketTaxAmount);
        if (order.custom.restockingFee && order.custom.restockingFee !== null && order.custom.restockingFee > 0) {
            // eslint-disable-next-line operator-assignment
            order.custom.restockingFee = (order.custom.restockingFee + restockingFee);
        } else {
            order.custom.restockingFee = restockingFee;
        }

        // Update totals and do not call calculate hook since it will override prices, promotions, and taxes
        order.updateTotals();
    }
}

module.exports = {
    updateOrderWithRestockingFee: updateOrderWithRestockingFee
};
