'use strict';

var Status = require('dw/system/Status');

var OrderUtilCode = {
    RESPONSE_CODE: {
        PATCH_SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order successfully updated.'
        },
        SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Shipment(s) successfully updated.'
        },
        NOTUPDATED: {
            status: Status.ERROR,
            code: 'NOTUPDATED',
            msg: "1 or more shipment(s) weren't updated cuz either a) request didn't transition it to 'shipped' or b) it wasn't already in a 'shipped' state."
        },
        NOTEXISTS: {
            status: Status.ERROR,
            code: 'NOTEXISTS',
            msg: "1 or more shipment(s) weren't updated cuz they didn't exist for the given order."
        },
        BADREQUEST: {
            status: Status.ERROR,
            code: 'BADREQUEST',
            msg: "Incorrect shipment(s) info 'c_shipmentsInfo' json."
        },
        ORDERCANCEL: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order Cancelled'
        },
        ORDERCANCEL_ITEMS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order items cancelled'
        },
        ERROR_ORDERCANCEL: {
            status: Status.ERROR,
            code: 'OrderCancelError',
            msg: "Couldn't cancel order, see log for details"
        },
        ERROR_ORDERCANCEL_ITEMS: {
            status: Status.ERROR,
            code: 'OrderCancelError',
            msg: "Couldn't cancel items on order, see log for details"
        },
        ORDERRETURN: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order Returned'
        },
        ERROR_ORDERRETURN: {
            status: Status.ERROR,
            code: 'OrderItemReturnError',
            msg: "Couldn't return order, see log for details"
        },
        INVALID_ACCESS_TOKEN: {
            status: Status.ERROR,
            type: 'InvalidAccessTokenException',
            msg: 'Unauthorized request! The access token is invalid.'
        },
        OPRDER_STATRUS_UPDATE_SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order Statuses Updated'
        },
        NOT_SOCIAL_ORDER: {
            status: Status.ERROR,
            code: 'BADREQUEST',
            msg: 'Order not placed through social channel'
        },
        ORDERREFUND: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order Refunded'
        },
        ORDERREFUND_ITEMS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Order Items Refunded'
        },
        SHIPPINGREFUND_COST: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Shipping COST Refunded'
        },
        ERROR_ORDER_REFUND: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'An error has occurred during order refund'
        },
        ERROR_ORDER_REFUND_ITEMS: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'An error has occurred during order items refund'
        },
        ERROR_SHIPPING_REFUND_COST: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'An error has occurred during shipping cost refund'
        },
        INVALID_PRODUCTS: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'ProductID {0} does not exists or is not available'
        },
        INSUFFICIENT_INVENTORY: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'ProductID {0} does not have enough inventory quantity available'
        },
        INVALID_SHIPMENT: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'Shipment {0} does not exists or is not available'
        },
        INTERNAL_ERROR: {
            status: Status.ERROR,
            code: 'INTERNAL_ERROR',
            msg: '{0}'
        },
        DEBUG_SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'Endpoint is accessible and access token is valid'
        },
        TAX_UPDATE_SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'The taxes have been updated'
        },
        TAX_UPDATE_ERROR: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'An error has occurred during updating Taxes'
        },
        APPEASEMENT_SUCCESS: {
            status: Status.OK,
            code: 'SUCCESS',
            msg: 'The appeasements have been created'
        },
        APPEASEMENT_ERROR: {
            status: Status.ERROR,
            code: 'ERROR',
            msg: 'An error has occurred during creating appeasement'
        }
    },

    EXTERNAL_ORDER_STATUS: {
        CREATED: 2,
        NEW: 3,
        RETURNED: 4,
        COMPLETED: 5,
        CANCELLED: 6,
        CANCELLED_PARTIAL: 7,
        REFUNDED: 8,
        PARTIAL_REFUND: 9
    },

    EXTERNAL_RETURN_STATUS: {
        CONFIRMED: 2,
        NEW: 3,
        RETURNED: 4,
        PARTIAL_RETURN: 5,
        CANCELLED: 6,
        PARTIAL_CANCELLED: 7,
        REFUNDED: 8,
        PARTIAL_REFUND: 9,
        PARTIAL_CONFIRMED: 10
    },

    EXTERNAL_LINE_ITEM_RETURN_STATUS: {
        NEW: 1,
        CONFIRMED: 2,
        CANCELLED: 3,
        RETURNED: 4,
        PARTIAL_RETURN: 5,
        PARTIAL_CANCELLED: 7,
        REFUNDED: 8,
        PARTIAL_REFUND: 9,
        PARTIAL_CONFIRMED: 10
    },

    ACTION: {
        REFUND_ORDER: 'refund_order',
        REFUND_ORDER_ITEMS: 'refund',
        RETURN_REQUEST: 'return_request'
    },

    OMS_SHIPPING_REFUND_STATUS: {
        REFUNDED: 0,
        PARTIAL_REFUND: 1
    }
};

module.exports = OrderUtilCode;
