'use strict';

var somCancellationReasonsByPlatform = require('~/cartridge/config/somCancellationReasonsByPlatform');

/**
 * @param {string} cancelReason - The reason for the cancellation request
 * @returns {boolean} - boolean representing whether the cancellation reason is a platform-generated reason
 */
function isCancelledByPlatform(cancelReason) {
    if (empty(cancelReason)) {
        return false;
    }

    var isPlataformCancellation = somCancellationReasonsByPlatform.reasons.map(function (reason) { return String(reason).toLowerCase(); }).indexOf(String(cancelReason).toLowerCase()) > -1;

    return isPlataformCancellation;
}

module.exports = {
    isCancelledByPlatform: isCancelledByPlatform
};
