'use strict';

var server = require('server');

var Logger = require('dw/system/Logger').getLogger('int_google_checkout', 'CartLink');
var LinkHelpers = require('int_google_checkout/cartridge/scripts/utils/LinkHelpers.js');

/**
 * Add products and your quantities to current basket
 */
server.get('Cart', function (req, res, next) {
    var BasketMgr = require('dw/order/BasketMgr');
    var Transaction = require('dw/system/Transaction');
    var cartHelper = require('*/cartridge/scripts/cart/cartHelpers');
    var URLUtils = require('dw/web/URLUtils');
    var ProductFactory = require('*/cartridge/scripts/factories/product');

    var checkout = empty(req.querystring.checkout) ? 'false' : req.querystring.checkout.toLowerCase();

    checkout = checkout === 'true';

    var action = res.viewData.action;

    try {
        if (empty(action) || !LinkHelpers.isAValidActionString(action)) {
            throw new Error('cartlink.action.not.valid');
        }

        var pidsObj = LinkHelpers.createPidsObj(action);

        if (!empty(pidsObj)) {
            var socialBasket = BasketMgr.getCurrentOrNewBasket();

            if (socialBasket) {
                Transaction.wrap(function () {
                    socialBasket.setChannelType(socialBasket.CHANNEL_TYPE_GOOGLE);

                    pidsObj.forEach(function (PIDObj) {
                        var product = ProductFactory.get({ pid: PIDObj.pid });
                        var quantity = PIDObj.qty;
                        var options = !empty(product.options) ? product.options[0] : {};
                        if (product.productType !== 'master' && product.productType !== 'variationGroup' && product.productType !== 'set') {
                            var PIDObjResult = cartHelper.addProductToCart(
                                socialBasket,
                                product.id,
                                quantity,
                                [],
                                options
                            );
                            if (PIDObjResult.error) {
                                Logger.error('Error occurred while {0}. Error Message: {1}', PIDObjResult.error, PIDObjResult.message);
                            }
                        }
                    });
                });

                if (checkout) {
                    res.redirect(URLUtils.url('Checkout-Begin'));
                    return next();
                }
            }
        }

        res.redirect(URLUtils.url('Cart-Show'));
    } catch (e) {
        Logger.error(e.message);
        res.redirect(URLUtils.url('Error-ErrorCode', 'err', e.message));
    }

    return next();
});

module.exports = server.exports();
