'use strict';

/**
 * Get a list of tracking number and carrier
 *
 * @param {Array} plis product line items
 * @returns {Array} List of Tracking number and carrier
 */
function getListOfTrackingNumberAndCarrier(plis) {
    var listOfTrackingNumberAndCarrie = [];
    plis.forEach(function (pli) {
        if (pli.custom.carrier != null && pli.custom.trackingNumber != null) {
            var data = {};
            data.carrier = pli.custom.carrier;
            data.trackingNumber = pli.custom.trackingNumber;
            listOfTrackingNumberAndCarrie.push(data);
        }
    });
    return listOfTrackingNumberAndCarrie;
}

/**
 * Execute Process Sfcc hook function
 *
 * @param {dw.order.order} order order
 * @returns {Object} object
 */
module.exports.processOrderUpdatesHook = function (order) {
    var tiktokService = require('~/cartridge/scripts/services/tiktokService');
    var customObjectHelper = require('~/cartridge/scripts/customObjectHelper');
    var Order = require('dw/order/Order');
    var tikTokSettings = customObjectHelper.getCustomObject(true);

    if (tikTokSettings == null && order == null) {
        return null;
    }

    var orderNo = order.orderNo;
    // externalChannelOrderStatus equals 6 (Canceled)
    var externalChannelOrderStatus = order.custom.externalChannelOrderStatus;
    var externalChannelOrderStatusDisplayValue = externalChannelOrderStatus.getDisplayValue();

    if (order.shippingStatus.value === Order.SHIPPING_STATUS_SHIPPED && externalChannelOrderStatus.value !== 6) {
        var productItems = order.getProductLineItems().toArray();
        var productLineItems = getListOfTrackingNumberAndCarrier(productItems);
        return tiktokService.processOrderUpdatesHook(tikTokSettings, orderNo, externalChannelOrderStatusDisplayValue, 'Shipped', productLineItems);
    // eslint-disable-next-line no-else-return
    } else if (externalChannelOrderStatus.value === 6) {
        return tiktokService.processOrderUpdatesHook(tikTokSettings, orderNo, 'CANCELED', null, []);
    }

    return { error: false };
};
