'use strict';

const List = require('dw/util/List');

/**
*
* Looks through each value in a collection and checks against provided predicate function. If
* it passes the predicate function then the value is added to the resulting array
*
* @function filter
* @memberof Collections
*
* @param {dw.util.Collection} collection Collection to apply filter to
* @param {Function} predicate predicate
* @param {Object=} context Context the iteratee function is bound to
*
* @returns {dw.util.Collection} collection with filtered values
*/
var filter = function (collection, predicate, context) {
    if (!empty(collection)) {
        var iterated = null;
        var iterator = collection.iterator();
        var returnedCollection = collection.clone();

        while (iterator.hasNext()) {
            iterated = iterator.next();

            if (!empty(context)) {
                if (predicate.call(context, iterated) !== true) {
                    returnedCollection.remove(iterated);
                }
            } else if (predicate(iterated) !== true) {
                returnedCollection.remove(iterated);
            }
        }

        return returnedCollection;
    }
    return List.EMPTY_LIST;
};

module.exports.filter = filter;
