'use strict';

/**
 * The Graph API version should be updated according to
 * https://developers.facebook.com/docs/graph-api/changelog/versions
 */
var VERSION = 'v19.0';

module.exports = {
    API_VERSION: VERSION,
    APP_ID: '414303402113306',
    ENDPOINTS: {
        COMMERCE_EXTENSION: '/fbe_business/?fbe_external_business_id={0}&access_token={1}&fields=commerce_extension',
        FEED_NOTIFICATION: '/' + VERSION + '/{0}/file_update',
        MBE_CONNECTION: '/' + VERSION + '/fbe_business/fbe_installs?fbe_external_business_id={0}&access_token={1}',
        POST_ONBOARDING: '/' + VERSION + '/{0}/post_onboarding_data',
        SPLASH_EXTENSION: 'https://www.commercepartnerhub.com/commerce_extension/splash/?app_id={0}&external_business_id={1}&business_name={2}&currency={3}&timezone={4}&external_client_metadata={5}&business_vertical={6}&channel={7}',
        VALIDATE_TOKEN: '/' + VERSION + '/me?fields=id,name&access_token={0}'
    },
    LOGGER_NAME: 'instagram',
    INSTAGRAM_CUSTOM_OBJECT_ID: 'instagram-settings',
    INSTAGRAM_DEFAULT_SCOPES: 'sfcc.catalogs.rw sfcc.orders.rw sfcc.promotions sfcc.promotions.rw',
    INSTAGRAM_DEFAULT_PRODUCT_FEED_JOB: 'Instagram-ExportFullFeeds',
    MBE: {
        BUSINESS_NAME: 'SalesforceCommerceCloud',
        BUSINESS_VERTICAL: 'ECOMMERCE',
        CHANNEL: 'COMMERCE'
    },
    SERVICE_RETRY_COUNT: 3,
    SERVICES: {
        INSTAGRAM: {
            BASE: 'facebook.graph'
        }
    },
    SOCIAL_CHANNEL_CUSTOM_OBJECT_DEFINITION: 'SocialChannels',
    SOCIAL_CHANNEL_CUSTOM_OBJECT_FEED_CONFIG: 'SalesChannelFeedConfig',
    WEBDAV_BASE_PATH: '/on/demandware.servlet/webdav/Sites'
};
