# Snapchat Social Integration

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Overview](#overview)
- [Prerequisites](#prerequisites)
    - [Create a Shopper Login and API Access Service (SLAS) Client](#create-a-shopper-login-and-api-access-service-slas-client)
    - [Create Snapchat OAuth App](#create-snapchat-oauth-app)
- [Installation Instructions](#installation-instructions)
    - [Install Dependencies](#install-dependencies)
    - [Upload Cartridges](#upload-cartridges)
    - [Update Cartridge Paths](#update-cartridge-paths)
    - [Import Data](#import-data)
        - [Import Common Data](#import-common-data)
        - [Import Snapchat Data](#import-snapchat-data)
    - [Assign Business Manager Permissions](#assign-business-manager-permissions)
    - [Configure WebDAV Permissions](#configure-webdav-permissions)
    - [Configure OCAPI Permissions](#configure-ocapi-permissions)
- [Configure Social Channels Integration](#configure-social-channels-integration)
    - [Snapchat Onboarding Configuration Table](#snapchat-onboarding-configuration-table)
      - [Snapchat Organization Details](#snapchat-organization-details)
      - [Snapchat Catalog Details](#snapchat-catalog-details)
      - [Salesforce B2C Commerce Details](#salesforce-b2c-commerce-details)
- [Sync Product Catalog](#sync-product-catalog)
    - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
    - [Review Job Configuration](#review-job-configuration)
        - [Export Full Feeds](#export-full-feeds)
        - [Export Delta Feeds](#export-delta-feeds)
- [Order Management System (OMS) Integration](#order-management-system-oms-integration)
</details>

## Overview
To build easy to use, API-driven capabilities that enable Salesforce Commerce Cloud (SFCC) customers to advertise and sell their products on Snapchat. Snapchat for Checkout is a module inside the _Social Checkout and Feeds Extension_, built from a set of business manager cartridges, that enable Commerce Cloud merchandisers to improve the discoverability of their products and sell those products on Snapchat.

Using the cartridges built for Snapchat, a customer can
1. Onboard onto Snapchat from within business manager
2. Publish an entire site catalog, or a category of products (and product updates) into Snapchat
3. Synchronize orders and order statuses between Snapchat and Salesforce

## Prerequisites
To integrate with Snapchat, please complete the following prerequisites:

1. Ensure you have met the required [SFCC Prerequisites](../README.md#prerequisites)
2. [Create a Shopper Login and API Access Service (SLAS) Client](#create-a-shopper-login-and-api-access-service-slas-client) and [Configure OCAPI Permissions](#configure-ocapi-permissions).
3. [Create a Snapchat Account](https://businesshelp.snapchat.com/s/article/set-up-snapchat) which will give you access to Ads Manager
4. [Set Up a Snapchat Business Account](https://businesshelp.snapchat.com/s/article/get-started)
5. [Create a Snapchat Ad Account](https://businesshelp.snapchat.com/s/article/create-ad-account)
6. [Create Snapchat OAuth App](#create-snapchat-oauth-app)
7. :warning: Contact your Snapchat representatives and have your OAuth App created above allow-listed by Snap. This step is required before you can continue with the onboarding process.

### Create a Shopper Login and API Access Service (SLAS) Client
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To integrate with Snapchat you will need to create a SLAS shopper **_private_** client ID. To do so, please follow the steps from the [Create a Shopper Login and API Access Service (SLAS) Client](./SLASClient.md).

> :warning: After you create your SLAS client, you will need to configure OCAPI permissions for your SLAS private client ID. Please review the [Configure OCAPI Permissions](#configure-ocapi-permissions) below.

### [Create Snapchat OAuth App](https://businesshelp.snapchat.com/s/article/api-apply)
1. Log in to [Ads Manager](https://ads.snapchat.com)
2. Continue to [https://business.snapchat.com](https://business.snapchat.com)
3. In the left-hand column, click **Business Details**
4. Click **+OAuth App**
5. Agree to the terms and conditions to activate access
6. **Create OAuth App**
    - **App Name**: Enter a name for your App (e.g.: `Salesforce Commerce Cloud`)
    - **Snap Redirect URI**: `https://snapchat-payments-portal.uc.r.appspot.com/v1/salesforce/redirect_callback`
    - Click **Create OAuth App**
    - ![Create Snapchat OAuth App](../docs/images/snapchat-create-oauth-app.png)
    - Click **Confirm** to confirm creation of your OAuth App. Once created, the App Name and Redirect URL cannot be updated.
    - > :warning: Make note of your App's Client ID and Client Secret Key as they will be entered as service credentials in SFCC.
        - ![Save Snapchat Client ID and Secret](../docs/images/snapchat-app-client-id-and-secret.png)

## Installation Instructions

### Install Dependencies
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Install Dependencies and Create dw.json](../README.md#install-dependencies-and-create-dwjson)

### Upload Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_social_base`: This cartridge contains code shared by all the social channels. It should be applied to both the storefront and Business Manager cartridge paths.
- `bm_socialchannels`: This cartridge contains the Business Manager controllers/UI logic to provide a new Business Manager extension that the site admin can use to integrate with Snapchat.
- `int_snapchat`: This cartridge contains the logic to integrate with Snapchat. It contains the service definitions as well as the logic to handle the customer object that stores the Snapchat details.
- `int_social_checkout`: This cartridge contains the logic to synchronize orders and order statuses between Snapchat and Salesforce.
- `bc_library`: This library contains all shared code for various demandware community projects. Ported from [demandware-library](https://github.com/SalesforceCommerceCloud/demandware-library)
- `bm_socialfeeds`: The custom feeds Business Manager module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more feeds are added. The extension comes with a BM UI which is easily usable and does not require any technical background.
- `int_socialfeeds`: The custom feeds module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more and more feeds are added.

> **NOTE**: In order to upload cartridges via npm scripts, you will need to replicate the dw.json in the [social_channels](../social_channels), [social_checkout](../social_checkout), and [social_feeds](../social_feeds) directories. The npm scripts will attempt to create a symlink, but it might be necessary for you to manually create this symlink for your operating system.

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:snapchat` to upload the `bm_socialchannels`, `int_snapchat`, `int_social_checkout`, `bc_library`, `bm_socialfeeds`, and `int_socialfeeds` cartridges to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

### Update Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Business Manager** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Under **Business Manager Site**, click the `Manage the Business Manager site` link.
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`
    - int_socialfeeds
    - bm_socialfeeds
    - bc_library
    - bm_socialchannels
    - int_social_base

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_snapchat:int_social_checkout:int_socialfeeds:bc_library:int_social_base:app_storefront_base`
    - int_snapchat
    - int_social_checkout
    - int_socialfeeds
    - bc_library
    - int_social_base

### Import Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

#### Import Common Data
1. Follow the steps from [Import and Update Configuration Data -> Import Common Data](../README.md#white_check_mark-import-common-data)

#### Import Snapchat Data
Snapchat Global data is found in [data/snapchat/snapchat_global](../data/snapchat/snapchat_global).

##### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:snapchat:global`
    - This will zip, upload, and import the data files into the sandbox specified in your dw.json file.

##### Option 2: Manually Zip, Upload, and Import via Business Manager
1. Zip the [data/snapchat/snapchat_global](../data/snapchat/snapchat_global) folder. From the root of the repo, run: `npm run data:snapchat:global:zip` (or manually zip the folder)
2. Log in to Business Manager
3. Go to **Administration** > **Site Development** > **Site Import & Export**
4. Click **Browse**
5. Select the `snapchat_global.zip` file from the root of the repo
6. Click **Upload**
7. Select `snapchat_global.zip`
8. Click **Import**
9. Click **OK**

### Assign Business Manager Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Administration** > **Organization** > **Roles & Permissions**
3. Select the role of your Business Manager user(s)
4. Click the **Business Manager Modules** tab
5. Select the specified Sites under **Sites** (e.g.: RefArch, RefArchGlobal)
6. Click **Apply**
    - ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
7. Under **Custom Objects**, select the _write_ checkbox for `Custom Object Editor`
    - ![Custom Object Editor](../docs/images/biz-mngr-role-custom-object-editor.png)
8. Under **Social Channels**, select the _write_ checkbox for `Snapchat Marketing API`
    - ![Snapchat Channel](../docs/images/biz-mngr-role-snapchat-channel.png)
9. At the bottom of the screen, Click **Update**
10. At the top of **Business Manager Modules** tab, switch context to **Organization**
11. Click **Apply**
    - ![Select Context - Org](../docs/images/biz-mngr-select-context-org.png)
12. Under **Operations**, select the _write_ checkbox for `Jobs`
13. Under **Operations**, select the _write_ checkbox for `Job History`
    - ![Job Permissions](../docs/images/biz-mngr-role-jobs.png)
14. Under **Social Product Feeds**, select the _write_ checkbox for **Social Product Feeds Definition**
    - ![Social Product Feeds Definition](../docs/images/biz-mngr-role-social-product-feeds-definition.png)
15. At the bottom of the screen, Click **Update**
16. Click the **WebDAV Permissions** tab
17. Scroll to the **Impex** section
18. Click the **Manage custom folders** link
19. In the text box, enter: `src/feeds/export`
    - ![Manage custom folders](../docs/images/biz-mngr-role-webdav-manage-custom-folders.png)
20. Click **Apply**
21. Under **Impex**, select the _write_ checkbox for `/impex/src/feeds/export/*`
    - ![WebDAV Permissions](../docs/images/biz-mngr-role-webdav-permissions.png)
22. At the bottom of the screen, Click **Update**

### Configure WebDAV Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Configure WebDAV Permissions](../README.md#white_check_mark-configure-webdav-permissions)

### Configure OCAPI Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

#### Shop API
1. Log in to Business Manager
2. Go to **Administration** > **Site Development** > **Open Commerce API Settings**
3. Select **Type**: `Shop`
4. Select **Context**: `Global`
5. Update the **Shop API** settings as follows. For the client ID, you will use your SLAS Client ID created in the [Create a Shopper Login and API Access Service (SLAS) Client](#create-a-shopper-login-and-api-access-service-slas-client) step.

```json
{
    "_v": "21.3",
    "clients": [
        {
            "client_id": "[-------SLAS Private Client ID-------]",
            "resources": [
                {
                    "resource_id": "/baskets",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*",
                    "methods": ["get", "patch", "delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/billing_address",
                    "methods": ["put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/coupons",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/coupons/*",
                    "methods": ["delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/customer",
                    "methods": ["put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/gift_certificate_items",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/gift_certificate_items/*",
                    "methods": ["delete", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/items",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/items/*",
                    "methods": ["delete", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/payment_instruments",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/payment_instruments/*",
                    "methods": ["delete", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/payment_methods",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/shipments",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/shipments/*",
                    "methods": ["delete", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/shipments/*/shipping_address",
                    "methods": ["put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/shipments/*/shipping_method",
                    "methods": ["put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/baskets/*/shipments/*/shipping_methods",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/categories/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/content/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/content_search",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*",
                    "methods": ["get", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/addresses",
                    "methods": ["get", "post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/addresses/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/baskets",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/orders",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/password",
                    "methods": ["put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/payment_instruments",
                    "methods": ["get", "post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/payment_instruments/*",
                    "methods": ["get", "delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/product_lists",
                    "methods": ["get", "post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/product_lists/*",
                    "methods": ["get", "patch", "delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/product_lists/*/items",
                    "methods": ["get", "post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/*/product_lists/*/items/*",
                    "methods": ["get", "patch", "delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/auth",
                    "methods": ["post", "delete"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/customers/auth/trustedsystem",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/gift_certificate",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*",
                    "methods": ["get", "patch", "put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*/payment_instruments",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*/payment_instruments/*",
                    "methods": ["delete", "patch"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*/payment_methods",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/product_lists",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/product_lists/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/product_lists/*/items",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/product_lists/*/items/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/product_search",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/products/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/promotions",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/promotions/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/search_suggestion",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/sessions",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/stores",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/stores/*",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                }
            ]
        }
    ]
}

```

## Configure Social Channels Integration
1. Log in to Business Manager
2. In Business Manager, Go to **Merchant Tools** > **Social Channels** > **Snapchat Marketing API**
3. Click **Accept Terms** button
    - ![Snapchat Accept Terms](../docs/images/snapchat-accept-terms.png)
4. Enter your `Snap Client ID` created in the [Create Snapchat OAuth App](#create-snapchat-oauth-app) step
5. Enter your `Snap Client Secret Key` created in the [Create Snapchat OAuth App](#create-snapchat-oauth-app) step
6. Click **Launch**
    - ![Snapchat Snapchat OAuth Form](../docs/images/biz-mngr-snapchat-onboarding-oauth-form.png)
7. Log in to Snapchat with your Snapchat account
    - ![Snapchat Login](../docs/images/biz-mngr-snapchat-login.png)
8. Click **Continue** to allow Snapchat to connect to Salesforce Commerce Cloud
    - ![Snapchat Connect SFCC](../docs/images/snapchat-connect-sfcc.png)
9. Refer to the [onboarding configuration table](#snapchat-onboarding-configuration-table) for help in filling out the onboarding form
    - ![Snapchat Onboarding Form](../docs/images/biz-mngr-snapchat-onboarding-form.png)
10. Click **Continue**
    - ![Snapchat Onboarding Complete](../docs/images/biz-mngr-snapchat-onboard-complete.png)

### Snapchat Onboarding Configuration Table

##### Snapchat Organization Details
| **Field Name**                                  | **Details**                                                                                                                |
|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|
| **Snap Client ID**                              | The Snapchat OAuth App Client ID created in the [Prerequisites](#prerequisites) section                                    |
| **Snap Client Secret Key**                      | The Snapchat OAuth App Client Secret created in the [Prerequisites](#prerequisites) section                                |
| **Snapchat Organization ID**                    | Select your Snapchat Organization ID                                                                                       |
| **Snapchat Ad Account ID**                      | Select your Snapchat Account ID                                                                                            |
| **Snapchat Pixel ID**                           | Select your Snapchat Pixel ID                                                                                              |

##### Snapchat Catalog Details
![Snapchat Catalog Onboarding](../docs/images/biz-mngr-snapchat-onboarding-catalog-form.png)

| **Field Name**                                  | **Details**                                                                                                                   |
|-------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|
| **Catalog ID or Name**                          | Select an existing catalog ID or provide the name of your Snapchat catalog that will be created during onboarding             |
| **Catalog Currency Code**                       | The currency code of your Snapchat catalog                                                                                    |
| **Product Feed ID or Name**                     | Select an existing product feed ID or provide the name of your Snapchat product feed that will be created during onboarding   |

#### Salesforce B2C Commerce Details
| **Field Name**                                    | **Details**                                                                                                                                                |
|---------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Business Manager User Login**                   | Business Manager login ID                                                                                                                                  |
| **Business Manager User Access Key / Password**   | Business Manager ["WebDAV File Access and UX Studio" access key](https://help.salesforce.com/s/articleView?id=cc.b2c_access_keys_for_business_manager.htm) |
| **Shopper Client ID (SLAS Private Client)**       | The SLAS Client ID configured in the [Create a SLAS Client](#create-a-shopper-login-and-api-access-service-slas-client) section                            |
| **Shopper Client Secret (SLAS Private Secret)**   | The SLAS Client secret configured in the [Create a SLAS Client](#create-a-shopper-login-and-api-access-service-slas-client) section                        |
| **Organization ID**                               | Salesforce Commerce API Org ID. Found at Administration > Site Development > Salesforce Commerce API Settings (e.g.: `f_ecom_zzte_053`)                    |
| **Short Code**                                    | Salesforce Commerce API Short Code. Found at Administration > Site Development > Salesforce Commerce API Settings (e.g.: `kv7kzm78`)                       |

## Sync Product Catalog

### Review Catalog Feed Configuration

Catalog feed configurations are based on the [custom feeds module](https://github.com/SalesforceCommerceCloud/custom-feeds) which allows merchants to easily create catalog feeds according to their needs. Once you define the template, you can schedule the feed to run at desired intervals. It is recommended to run this job at the same frequency you anticipate changes to your catalog, or whenever you replicate to production.

1. Log in to Business Manager
2. Go to **Administration** > **Social Product Feeds** > **Social Product Feeds Definition**

| **Field**                    | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
|------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Template**                 | The default feed configuration will be loaded into the `snapchat-feed` record within the **SalesChannelFeedConfig** custom object. Initial configuration is based on the SFRA reference website. It is recommended to review the header and field mapping according to the catalog setup for your storefront and update it as required. Product field mappings can be found in [Social Product Feeds](./feedConfig.md). Possible areas of interest:<br/><ul><li>`image type="large"`: configure proper image view type that should be exported</li><li>`price type="usd-m-list-prices"`: configure the list pricebook</li></ul>.  |
| **Folder Name**              | `IMPEX/src/feeds/export/social/snapchat/product`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| **File Name**                | `{{updateType}}-snapchat-feed-{{site_id}}-{{timestamp}}-{{locale}}.txt`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| **Category Specific Export** | The category to export. Enter `root` to export all products or a specific category (e.g.: `social-snapchat`). Ensure the category you select is marked as "online".                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| **Channel Type**             | `Snapchat`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **Google Shopping Category** | Category based on the kind of products that are sold on your site                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| **Available for Sites**      | The site(s) for which the products need to be exported. It is recommended to run & configure a feed template once per site. Custom object IDs can be defined in the `CustomObjectIds` job parameter within the **Product Full Feed** job step in the `Snapchat-ExportFullFeeds` scheduled job.                                                                                                                                                                                                                                                                                                                                    |

### Review Job Configuration

#### Export Full Feeds
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `Snapchat-ExportFullFeeds` job
4. Click on the **Job Steps** tab and configure job steps
    - **ProductFullFeed**
        - Check `ExportCatalogs`
        - Configure `DeltaCatalogInDays`; for full feeds, this value should be `0`
        - Configure `CustomObjectIds`, comma separated custom object IDs used to build a feed (e.g.: `snapchat-feed`)
        - > :exclamation: Please, note that this job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object
        - Configure `Hostname`
        - Click **Assign**
        - ![Snapchat Export Product Full Feed](../docs/images/biz-mngr-snapchat-export-feeds-product-full-feed.png)
    - **CreateFeedUpload**
        - **FileFolder**: `/src/feeds/export/social/snapchat/product`
        - **FilePattern**: `^(delta|full)-snapchat-feed-{{siteId}}.*\.(csv|txt)$`
        - Click **Assign**
        - ![Snapchat Create Feed Upload](../docs/images/biz-mngr-snapchat-create-feed-upload.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run
6. On the **Snapchat Marketing API** screen, you will be able to view the Create Feed Upload Status (**Site** > **Merchant Tools** > **Social Channels** > **Snapchat Marketing API**)
   - ![Snapchat Create Feed Upload Status](../docs/images/biz-mngr-snapchat-create-feed-upload-status.png)

#### Export Delta Feeds
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `Snapchat-ExportDeltaFeeds` job
4. Click on the **Job Steps** tab and configure job steps
    - **ProductDeltaFeed**
        - Check `ExportCatalogs`
        - Configure `DeltaCatalogInDays`, `0.1` until `1` (`0.1` = 2.4 hours; `0.2` = 4.8 hours;...; `1` = 24 hours)
        - Configure `CustomObjectIds`, comma separated custom object IDs used to build a feed (e.g.: `snapchat-feed`)
        - > :exclamation: Please, note that this job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object
        - Configure `Hostname`
        - Click **Assign**
        - ![Snapchat Export Product Delta Feed](../docs/images/biz-mngr-snapchat-export-feeds-product-delta-feed.png)
    - **CreateFeedUpload**
        - **FileFolder**: `/src/feeds/export/social/snapchat/product`
        - **FilePattern**: `^(delta|full)-snapchat-feed-{{siteId}}.*\.(csv|txt)$`
        - Click **Assign**
        - ![Snapchat Create Feed Upload](../docs/images/biz-mngr-snapchat-create-feed-upload.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run
6. On the **Snapchat Marketing API** screen, you will be able to view the Create Feed Upload Status (**Site** > **Merchant Tools** > **Social Channels** > **Snapchat Marketing API**)
    - ![Snapchat Create Feed Upload Status](../docs/images/biz-mngr-snapchat-create-feed-upload-status.png)

#### Create Feed Upload (Optional)
This job is optional as the **CreateFeedUpload** step is executed in both the `Snapchat-ExportFullFeeds` and `Snapchat-ExportDeltaFeeds` job schedules. The [feed upload](https://marketingapi.snapchat.com/docs/#create-a-feed-upload) notifies Snapchat that a new catalog file is ready for pickup and ingestion. Only one file can be processed at a time and each file must finish processing before a new file can be processed. If multiple files are present in the `/src/feeds/export/social/snapchat/product` directory, this job can be run on a schedule or manually so that all files are sent to Snapchat for ingestion.
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `Snapchat-CreateFeedUpload` job
4. Click on the **Job Steps** tab and configure job steps
    - **CreateFeedUpload**
        - **FileFolder**: `/src/feeds/export/social/snapchat/product`
        - **FilePattern**: `^(delta|full)-snapchat-feed-{{siteId}}.*\.(csv|txt)$`
        - Click **Assign**
        - ![Snapchat Create Feed Upload](../docs/images/biz-mngr-snapchat-create-feed-upload.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run
6. On the **Snapchat Marketing API** screen, you will be able to view the Create Feed Upload Status (**Site** > **Merchant Tools** > **Social Channels** > **Snapchat Marketing API**)
    - ![Snapchat Create Feed Upload Status](../docs/images/biz-mngr-snapchat-create-feed-upload-status.png)

## Order Management System (OMS) Integration
Please review and complete the steps from the [Order Management System Integration](./oms.md#overview) document.
