# Order Management Social Integration Managed Package

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Managed Package Installation](#managed-package-installation)
- [Unmanaged Package Installation](#unmanaged-package-installation)
    - [Install Salesforce CLI](#install-salesforce-cli)
    - [Deployment Option 1: Via Salesforce CLI](#deployment-option-1-via-salesforce-cli)
    - [Deployment Option 2: Via Visual Studio Code](#deployment-option-2-via-visual-studio-code)
- [Package Configuration](#package-configuration)
    - [Remote Site Settings](#remote-site-settings)
    - [Order Status Update Params](#order-status-update-params)
        - [Configuration Table](#order-status-update-params-configuration-table)
    - [Validate SFCC Configuration](#validate-sfcc-configuration)
    - [Export Order Summary Feature](#export-order-summary-feature)
    - [Order Export Header Status Map](#order-export-header-status-map)
        - [Configure Order Export Header Status Map](#configure-order-export-header-status-map)
    - [Order Export Line Status Map](#order-export-line-status-map)
        - [Configure Order Export Line Status Map](#configure-order-export-line-status-map)
    - [Order Export Carrier Map](#order-export-carrier-map)
    - [Configure Permissions](#configure-permissions)
        - [Social OMS Integration Permission Set](#social-oms-integration-permission-set)
        - [Order Management Self Service Permission Set](#order-management-self-service-permission-set)
    - [Order Cancellations](#order-cancellations)
        - [Order Cancellation Reason Codes](#order-cancellation-reason-codes)
- [Configure OCAPI Permissions](#configure-ocapi-permissions)
- [Order Returns](#order-returns)

</details>

## Overview
This package can be used if your OMS system uses Salesforce Order Management. Order status event updates are sent from OMS systems into SFCC in a push model. SFCC will then generate the order status feed and send it to the social channel at regular intervals.

## Prerequisites
1. To utilize the Social Integration features, your SFDC environment must meet specific minimum requirements. The primary requirement is the configuration of Salesforce Order Management System (OMS). For guidance on OMS configuration, please refer to the [Salesforce Order Management Implementation Guide for B2C Commerce](https://resources.docs.salesforce.com/latest/latest/en-us/sfdc/pdf/sfom_impl_b2ce.pdf)
2. You must also have an SFCC instance connected to this SF OMS instance.

## Managed Package Installation
To install a managed package, simply log in to your Salesforce environment and access the package installation URL. Refer to the table below for detailed information about the **Social Integration** package:

| **Package Name**           | **Type** | **Version** | **Installation URL**                                                              |
|----------------------------|----------|-------------|-----------------------------------------------------------------------------------|
| Social Integration Package | Managed  | 0.4.0.3     | https://login.salesforce.com/packaging/installPackage.apexp?p0=04tHu000003tkhNIAQ |

After accessing the URL:
1. Click **Install for Admins Only**
2. Click **Install**
![Install Package](../docs/images/oms-package-install.png)

## Unmanaged Package Installation
The unmanaged packaged is located in the [social_oms_integration](../social_oms_integration) directory of this repository. To deploy to your org, you will need to install the Salesforce CLI and choose from one of the deployment options listed below.

### Install Salesforce CLI
Refer to the [following documentation](https://developer.salesforce.com/docs/atlas.en-us.sfdx_setup.meta/sfdx_setup/sfdx_setup_intro.htm) to install the latest Salesforce CLI

```shell
npm install @salesforce/cli --global
```

### Deployment Option 1: Via Salesforce CLI

Register Your Salesforce Org with SFDX
1. Authenticate against your Salesforce Org by executing the following CLI command:

> Your loginUrl should be in the form of https://login.salesforce.com or https://test.salesforce.com. SFDX will use this url to ask for your deployment and integration authorization.

```shell
sf org login web -r [insert your loginUrl here] -a [insert your org alias here]
```

List your SFDX configured Orgs by executing the following CLI command:
```shell
sf org list
```

2. Set your Salesforce Org's username as the SFDX default via the following CLI command:

```shell
sf config set target-org=[insert your Salesforce Org Username Here]
```

Confirm that your username is the default user for your SFDX environment:
```shell
sf org list
```

3. Deploy package to org
   Navigate to the `social_oms_integration` directory
```shell
cd social_oms_integration
```

To deploy using your default org username above:
```shell
sf project deploy start -d force-app
```

To deploy, using an alternate org username:
```shell
sf project deploy start -d force-app -o [insert your Salesforce Org Username Here]
```

### Deployment Option 2: Via Visual Studio Code

1. Open [Visual Studio Code](https://code.visualstudio.com/) and install the [Salesforce Extension Pack](https://marketplace.visualstudio.com/items?itemName=salesforce.salesforcedx-vscode)
    - ![Salesforce Extension Pack](../docs/images/som-salesforce-extension-pack.png)
2. Open the [social_oms_integration](../social_oms_integration) project using Visual Studio Code
3. Press **Ctrl+Shift+P** (Windows) or **Cmd+Shift+P** (macOS) to make the command palette appear
4. Type `SFDX: Authorize an Org`
    - ![Authorize an Org](../docs/images/som-vs-code-auth-an-org.png)
5. To accept the default login URL, press **Enter**
6. Enter a project alias
7. Right-click the **force-app** folder
8. Click **SFDX: Deploy Source to Org**
    - ![Deploy Source to Org](../docs/images/vs-code-deploy-source-to-org.png)

## Package Configuration

### Remote Site Settings
To enable REST calls from a Salesforce org to SFCC, you need to add the SFCC URL to the list of allowed URLs. Follow these steps to include a URL in the allowed URLs list:

1. Log in to your Salesforce environment
2. Navigate to **Setup** > **Security** > **Remote Site Settings**
    - ![Remote Site Settings](../docs/images/oms-package-remote-site-settings.png)
3. Click on **New Remote Site**
    - ![New Remote Site](../docs/images/oms-package-new-remote-site.png)
4. Fill in the information for the SFCC domain where the OMS will send the order status updates
    - ![Remote Site Config](../docs/images/oms-package-remote-site-settings-config.png)

### Order Status Update Params
To utilize the order export feature, you must create an **Order Status Update Param** custom metadata record containing the access credentials for the SFCC site configured above. Follow the steps below to access this object.

1. Log in to the Salesforce environment
2. Navigate to **Setup**
3. Enter `metadata` in Quick Find and select **Custom Metadata Types**
4. Click on **Manage Records** link next to the **Order Status Update Params** object
    - ![Order Status Update Params Manage Records](../docs/images/oms-package-order-status-update-manage-records.png)
5. Click **New**
    - ![Order Status Update Params New](../docs/images/oms-package-order-status-update-new.png)
6. Fill in each field with its respective information. Please note that this record is of utmost importance for the integration to work. Fill in the fields carefully to avoid potential errors. Refer to the below [Order Status Update Params Configuration Table](#order-status-update-params-configuration-table) for mapping values.
    - ![Order Status Update Params Config](../docs/images/oms-package-order-status-update-config.png)
7. Click **Save**

#### Order Status Update Params Configuration Table
| **Field Name**                     | **Value**                                                                  | **Notes**                                                  |
|------------------------------------|----------------------------------------------------------------------------|------------------------------------------------------------|
| **Label**                          | `Prod` or `Non Prod`                                                       |                                                            |
| **Order Status Update Param Name** | `Prod` or `Non_Prod`                                                       |                                                            |
| **Endpoint**                       | `https://zzte-053.dx.commercecloud.salesforce.com/dw/oauth2/access_token?` |                                                            |
| **Order Status Endpoint**          | `https://zzte-053.dx.commercecloud.salesforce.com`                         |                                                            |
| **API Version**                    | `v23_2`                                                                    | OCAPI API Version                                          |
| **Client ID**                      | `abbaf781-a035-442b-8e25-f850caa5a566`                                     | OCAPI Account Manager Client ID                                            |
| **Client Credential**              | `my_ocapi_client_secret123!`                                               | OCAPI Account Manager Client Secret                                        |
| **Grant Type**                     | `urn:demandware:params:oauth:grant-type:client-id:dwsid:dwsecuretoken`     |                                                            |
| **Username**                       | `admin@salesforce.com`                                                     | Business Manager Username                                  |
| **Access Key**                     | `3tJ(B1xhDf730sgqgLWGO!-y8VeOdZ]!_IPkQKnk_`                                | Business Manager **Agent User Login and OCAPI** access key |
| **Site ID**                        | `RefArch`                                                                  | SFCC Site ID                                               |

### Validate SFCC Configuration
After you have completed the [Remote Site Settings](#remote-site-settings) and [Order Status Update Params](#order-status-update-params) sections, you can test your connection by running the included [SFCC_OCAPI_Access_Token_Callout Anonymous Amex Script](../social_oms_integration/scripts/apex/SFCC_OCAPI_Access_Token_Callout.apex).

1. Log in to the Salesforce environment
2. Click the **gear icon** in the upper right hand corner
3. Click **Developer Console**
    - ![Developer Console](../docs/images/oms-package-developer-console.png)
4. Click **Debug**
5. Click **Open Execute Anonymous Window**
    - ![Open Execute Anonymous Window](../docs/images/oms-package-exec-anon.png)
6. In the window, paste in the contexts of [social_oms_integration/scripts/apex/SFCC_OCAPI_Access_Token_Callout.apex](../social_oms_integration/scripts/apex/SFCC_OCAPI_Access_Token_Callout.apex)
7. To use the custom metadata input in the [Order Status Update Params](#order-status-update-params) section, leave the script as-is. If you want to fill in test values manually, you can set the `useCustomMetadataValues` boolean value to false and fill in your SFCC values in the script manually.
8. Check the **Open Log** box
9. Click **Execute**
    - ![SFCC Callout](../docs/images/oms-package-sfcc-callout.png)
10. The log file will open automatically. Check the **Debug Only** box. Confirm an access token was returned.
    - ![SFCC Callout Debug](../docs/images/oms-package-exec-anon-callout-debug.png)

### Export Order Summary Feature
When updating the order status, a series of logic processes are triggered to send information to SFCC. These processes include two main flows, listed below.
1. creating an order export record
2. invoking an Apex action that sends the data to SFCC

Below is a visual representation of this feature's logic:
- ![Export Order Summary Feature](../docs/images/oms-package-export-order-summary-flow.png)

### Order Export Header Status Map
To perform order-level status mappings from OMS to SFCC, utilize the `Order Export Header Status Map` object. Create records in this object and populate the fields with the mapping details. Refer to the [Order Status Data Map](./oms.md#order-status-data-map) for mapping values.

1. `OMS_Status__c`: Enter the OMS status to be mapped
2. `Export_Status__c`: Specify the status for export to SFCC

#### Configure Order Export Header Status Map
You can use the included [social_oms_integration/scripts/apex/Insert_Order_Export_Header_Status_Map__c.apex](../social_oms_integration/scripts/apex/Insert_Order_Export_Header_Status_Map__c.apex) to configure your Order Export Header Status Map records. This script will insert the records for you. Follow the steps below to run the script.

1. Log in to the Salesforce environment
2. Click the **gear icon** in the upper right hand corner
3. Click **Developer Console**
    - ![Developer Console](../docs/images/oms-package-developer-console.png)
4. Click **Debug**
5. Click **Open Execute Anonymous Window**
    - ![Open Execute Anonymous Window](../docs/images/oms-package-exec-anon.png)
6. In the window, paste in the contexts of [social_oms_integration/scripts/apex/Insert_Order_Export_Header_Status_Map__c.apex](../social_oms_integration/scripts/apex/Insert_Order_Export_Header_Status_Map__c.apex)
7. Review the mappings to ensure they match your desired OMS and SFCC values
8. Check the **Open Log** box
9. Click **Execute**
    - ![Order Export Header Status Map](../docs/images/oms-package-order-export-header-status-map.png)
10. The log file will open automatically. Check the **Debug Only** box. Confirm your mappings where successfully saved:

```shell
sf data query -q "SELECT OMS_Status__c, Export_Status__c FROM Order_Export_Header_Status_Map__c"
```
| **OMS_Status__c**   | **Export_Status__c** |
|---------------------|----------------------|
| Activated           | 3                    |
| Approved            | 3                    |
| Cancelled           | 6                    |
| Created             | 3                    |
| Draft               | 2                    |
| Fulfilled           | 5                    |
| Partially Fulfilled | 3                    |
| Pending             | 3                    |
| Pickup              | 3                    |
| Rejected            | 3                    |
| Released            | 3                    |
| Waiting Allocation  | 3                    |
| Waiting Fulfillment | 3                    |
| Waiting to Fulfill  | 3                    |

### Order Export Line Status Map
To perform line-item level status mappings from OMS to SFCC, utilize the `Order Export Line Status Map` object. Create records in this object and complete the fields with the mapping details. Refer to the [Order Status Data Map](./oms.md#order-status-data-map) for mapping values.

1. `OMS_Status__c`: Enter the OMS status to be mapped
2. `Export_Status__c`: Specify the status for export to SFCC

#### Configure Order Export Line Status Map
You can use the included [social_oms_integration/scripts/apex/Insert_Order_Export_Line_Status_Map__c.apex](../social_oms_integration/scripts/apex/Insert_Order_Export_Line_Status_Map__c.apex) to configure your Order Export Line Status Map records. This script will insert the records for you. Follow the steps below to run the script.

1. Log in to the Salesforce environment
2. Click the **gear icon** in the upper right hand corner
3. Click **Developer Console**
    - ![Developer Console](../docs/images/oms-package-developer-console.png)
4. Click **Debug**
5. Click **Open Execute Anonymous Window**
    - ![Open Execute Anonymous Window](../docs/images/oms-package-exec-anon.png)
6. In the window, paste in the contexts of [social_oms_integration/scripts/apex/Insert_Order_Export_Line_Status_Map__c.apex](../social_oms_integration/scripts/apex/Insert_Order_Export_Line_Status_Map__c.apex)
7. Review the mappings to ensure they match your desired OMS and SFCC values
8. Check the **Open Log** box
9. Click **Execute**
    - ![Order Export Line Status Map](../docs/images/oms-package-order-export-line-status-map.png)
10. The log file will open automatically. Check the **Debug Only** box. Confirm your mappings where successfully saved:

```shell
sf data query -q "SELECT OMS_Status__c, Export_Status__c FROM Order_Export_Line_Status_Map__c"
```
| **OMS_Status__c**   | **Export_Status__c** |
|---------------------|----------------------|
| Allocated           | 0                    |
| Canceled            | 6                    |
| Fulfilled           | 2                    |
| Ordered             | 0                    |
| Partially Allocated | 0                    |
| Partially Fulfilled | 1                    |
| Reshipped           | 2                    |
| Return Initiated    | 0                    |
| Returned            | 0                    |

### Order Export Carrier Map
To use carrier mapping on the shipment object related to the order, follow the steps below:

1. Log in to the Salesforce environment
2. Navigate to **Setup**
3. Enter `metadata` in Quick Find and select **Custom Metadata Types**
4. Click on **Manage Records** link next to the **Order Export Carrier Map** object
    - ![Order Export Carrier Map Manage Records](../docs/images/oms-package-order-export-carrier-map-manage-records.png)
5. Click **New**
    - ![Order Export Carrier Map New](../docs/images/oms-package-order-export-carrier-map-new.png)
6. Fill in the carrier mapping information in the `Provider__c` and `Carrier__c` fields
   - `Provider__c`: Enter the value related to the 'Provider' field in the Shipment object (Input)
   - `Carrier__c`: Enter the value that will be sent for integration (Output)
   - The `Label` and `Name` fields are mandatory in any custom metadata, but they are not considered in the integration; you can input any value.
   - ![Order Export Carrier Map Add Record](../docs/images/oms-package-order-export-carrier-map-add-record.png)
> :warning: If no mapping is found for the value of the Shipment field, a process exception record will be created and that shipment will **not** be sent to SFCC.

### Configure Permissions

#### Social OMS Integration Permission Set
The Order Management Social Integration Package includes the **Social OMS Integration** permission set that must be assigned to the user who will be running the integration. To assign the permission set, follow the steps below:

1. Log in to the Salesforce environment
2. Navigate to **Setup**
3. Enter `permission` in Quick Find and select **Permission Sets**
4. Click on **Social OMS Integration**
    - ![Social OMS Integration Permission Set](../docs/images/oms-package-permission-set.png)
5. Click **Manage Assignments**
   - ![Social OMS Integration Permission Set - Manage Assignments](../docs/images/oms-package-permission-set-manage-assignments.png)
6. Click **Add Assignments**
    - ![Social OMS Integration Permission Set - Add Assignments](../docs/images/oms-package-permission-set-add-assignments.png)
7. Select the user to whom you want to assign the permission set

#### Order Management Self Service Permission Set
After self-provisioning the connection between B2C Commerce and Order Management with the **Order Self-Service** connection type, you will have the `OMSelfServicePermissionSet` permission set available in your org. Commerce Cloud connects to the force platform without a user via the `Salesforce.Internal.LOM` internal service and uses the `OMSelfServicePermissionSet` permission set to control access levels.

To self-provision the connection between B2C Commerce and Order Management, follow the steps on the **Connect B2C Commerce and Order Management** page in the [Salesforce Order Management Implementation Guide for B2C Commerce](https://resources.docs.salesforce.com/latest/latest/en-us/sfdc/pdf/sfom_impl_b2ce.pdf).

In the `OMSelfServicePermissionSet` permission set, verify the object permissions access by following the steps below:
1. Log in to the Salesforce environment
2. Navigate to **Setup**
3. Enter `permission` in Quick Find and select **Permission Sets**
4. Click on **OMSelfServicePermissionSet**
    - ![OMSelfServicePermissionSet Permission Set](../docs/images/oms-package-om-self-service-permission-set.png)
5. Click **Object Settings**
    - ![OMSelfServicePermissionSet Permission Set - Object Settings](../docs/images/oms-package-om-self-service-permission-set-object-settings.png)
6. Click **Fulfillment Orders** to edit the object permissions
7. Click **Edit**
8. Ensure _at least_ the **Read** and **Edit** object permissions are assigned
9. Click **Save**
    - ![OMSelfServicePermissionSet Permission Set - Object Permissions](../docs/images/oms-package-om-self-service-permission-set-object-permissions.png)
10. At the top of the screen, select a new object and repeat steps 6-9 for the remaining objects listed below:
    - ![OMSelfServicePermissionSet Permission Set - Select New Object](../docs/images/oms-package-om-self-service-permission-set-select-new-object.png)
    - Accounts
    - Orders
    - Order Products
    - Order Product Summaries
    - Shipments

### Order Cancellations
Order cancellations are sent to OMS via a SFCC OCAPI order PATCH request. It is important to note that, in the current implementation, the line items **can not** be cancelled on the OMS side if they are already allocated to a Fulfillment Order. If the line items are in a Fulfillment Order, the order cancellation will fail. The order cancellation will only succeed if the line items are unallocated.

We recommend that you pause the order fulfillment process in OMS during the remorse period for your social channel. This will allow the customer to cancel the order in the social channel and the order cancellation will succeed in OMS. Once the remorse period has passed, you can resume the Order Fulfillment process in OMS.

Alternatively, you can edit the SFCC order cancellation PATCH hook so that it:
1. Cancels the order fulfillment items via the [cancelFulfillmentOrderItem flow core action](https://developer.salesforce.com/docs/atlas.en-us.230.0.order_management_developer_guide.meta/order_management_developer_guide/flow_ref_elements_om_actions_cancel_fo_item.htm) or via the [REST API](https://developer.salesforce.com/docs/atlas.en-us.chatterapi.meta/chatterapi/connect_resources_sfom_fulfillment_orders_cancel_items.htm)
2. Cancels the order item summaries via the [cancelOrderItemSummariesSubmit flow core action](https://help.salesforce.com/s/articleView?id=sf.flow_ref_elements_om_actions_cancel_ois_submit.htm&type=5) or via the [REST API](https://developer.salesforce.com/docs/atlas.en-us.chatterapi.meta/chatterapi/connect_resources_sfom_order_summaries_submit_cancel.htm)

#### Order Cancellation Reason Codes
When order line items are cancelled in OMS, the cancellation reason code must exist in OMS in order for the items to be cancelled successfully. To configure the cancellation reason codes, follow the steps below:

1. Log in to the Salesforce environment
2. Navigate to **Setup**
3. Click **Object Manager**
4. Enter `Order Product Summary Change` in Quick Find
5. Click **Order Product Summary Change**
    - ![Order Product Summary Change](../docs/images/oms-package-order-product-summary-change.png)
6. Click **Fields & Relationships**
7. Click **Reason**
8. In the "Reason Picklist Values" section, click **New**
    - ![Reason Picklist Values - New](../docs/images/oms-package-reason-picklist-values-new.png)
9. Enter the cancellation reason codes listed in the table below
    - ![Order Product Summary Change Reason](../docs/images/oms-package-reason-picklist-values.png)
10. Click **Save**

| **Reason**                         | **Social Channel** |
|------------------------------------|--------------------|
| `cancelled_by_buyer`               | TikTok             |
| `cancelled_by_seller`              | TikTok             |
| `cancelled_by_tiktok`              | TikTok             |
| `IG_AUTOCANCEL`                    | Instagram          |
| `IG_CUSTOMER_REQUEST`              | Instagram          |
| `IG_CUSTOMER_REQUEST_VIA_MERCHANT` | Instagram          |
| `IG_FRAUD`                         | Instagram          |
| `IG_MERCHANT_INVENTORY`            | Instagram          |
| `IG_OTHER`                         | Instagram          |
| `IG_PAYMENT_DECLINED`              | Instagram          |
| `IG_SUPPORT`                       | Instagram          |


## Configure OCAPI Permissions
In order for OMS to send order status updates to SFCC, SFCC must have the following OCAPI permissions configured. Ensure your use the same Account Manager Client ID that was configured in the [Order Status Update Params](#order-status-update-params) section.

1. Log in to Business Manager
2. Go to **Administration** > **Site Development** > **Open Commerce API Settings**
3. Select **Type**: `Shop`
4. Select **Context**: `Global`
5. Update the **Shop API** settings as follows:

```json
{
    "_v": "21.3",
    "clients": [
        {
            "client_id": "[----OCAPI ACCOUNT MANAGER Client ID----]",
            "resources": [
                {
                    "resource_id": "/order_search",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*",
                    "methods": ["get", "patch", "put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                }
            ]
        }
    ]
}
```
## Order Returns

The return order and order line item status updates are sent to Salesforce commerce cloud using the following logic

#### Return rejected scenarios

| **Scenario** | **Return Order (c_externalReturnStatus)** | **Return Order Line Item (c_externalLineItemReturnStatus)** |
| ------------- | ------------- | ------------- |
| **Only a few line items are rejected**, for rejected items - quantity rejected = Items quantity received | PARTIAL_CANCEL (7) | CANCELLED (6) |
| **All return line items are rejected**, for all items, quantity rejected = Items quantity received | CANCELLED (6) | CANCELLED (6) |
| **For all line items there is parial rejection**,  quantity rejected < Items quantity received | PARTIAL_CANCEL (7) | PARTIAL_CANCEL (7) |

#### Return completed scenarios

| **Scenario** | **Return Order (c_externalReturnStatus)** | **Return Order Line Item (c_externalLineItemReturnStatus)** |
| ------------- | ------------- | ------------- |
| **Only a few line items are returned**, for returned items - quantity returned = Items quantity received | PARTIAL_RETURNED (5) | RETURNED (4) |
| **All return line items are returned**, for all items, quantity returned = Items quantity received | RETURNED (4) | RETURNED (4) |
| **For all line Items quantity returned <  quantity received** | PARTIAL_RETURNED (5) | PARTIAL_RETURNED (5) |

#### Return approved scenario (only at the return order level)

| **Scenario** | **Return Order (c_externalReturnStatus)** | **Return Order Line Item (c_externalLineItemReturnStatus)** |
| ------------- | ------------- | ------------- |
| Return order status =  "approved" | CONFIRMED (3) | CONFIRMED (3) |
