# Order Management System (OMS) Integration

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Order Management Social Integration Managed Package](./omsPackage.md)
- [Overview](#overview)
- [Order Status Data Map](#order-status-data-map)
- [Order Export Job](#order-export-job)
- [Salesforce Order Management](#salesforce-order-management)
  - [Upload Salesforce Order Management Cartridges](#upload-salesforce-order-management-cartridges)
  - [Update Salesforce Order Management Cartridge Path](#update-salesforce-order-management-cartridge-path)
- [Other Order Management Systems](#other-order-management-systems)
  - [Upload Cartridges](#upload-cartridges)
  - [Update Cartridge Path](#update-cartridge-path)

</details>

## Order Management Social Integration Managed Package
Please refer to the [following documentation](./omsPackage.md) for installation of the [Order Management Social Integration Managed Package](../social_oms_integration)

## Overview
Depending on the Order Management System (OMS), the following patterns are possible to integrate order statuses back to the social channel:

1. Re-using the existing import of order status back into SFCC - this is for customers who import order status from their ERP or OMS systems back into Commerce Cloud. SFCC will then generate the order status feed and send it to the social channel directly at regular intervals.
2. Order status batch export to SFCC from OMS system. The social channel can then pick up the order status file from the WebDAV location that is hosted on SFCC
3. Order Status job to query order status from OMS system -  a custom job that is run at a pre-defined schedule to get order statuses from external OMS systems. SFCC will then generate the order status feed and send it to the social channel directly at regular intervals.
4. Order status event updates are sent from OMS systems into SFCC in a push model. SFCC will then generate the order status feed and send it to the social channel at regular intervals. This is the pattern of integration with [Salesforce Order Management](#salesforce-order-management).
5. OMS sends order status update to the social channel by directly calling the social channel's API.

## Order Status Data Map
> For patterns 1 through 4, the order status feeds from SFCC into the social channel are standardized on the following order statuses at the order and line item levels.

**Order**
| **Field**                         | **Custom / System** | **Value** | **Display Value**           | **Description**                                                                                                            |
|-----------------------------------|---------------------|-----------|-----------------------------|----------------------------------------------------------------------------------------------------------------------------|
| **c_externalExportStatus**        | Custom              | 0         | EXPORT_STATUS_NOTEXPORTED   | Export Status is not exported                                                                                              |
|                                   |                     | 1         | EXPORT_STATUS_EXPORTED      | Export Status is exported                                                                                                  |
|                                   |                     | 2         | EXPORT_STATUS_READY         | Export Status is ready to be exported                                                                                      |
| **c_externalChannelOrderStatus**  | Custom              | 2         | CREATED                     | Order Status is created (reserved for future use)                                                                          |
|                                   |                     | 3         | NEW                         | Order Status is new, not shipped                                                                                           |
|                                   |                     | 5         | COMPLETED                   | Order Status is completed, shipped                                                                                         |
|                                   |                     | 6         | CANCELLED                   | Order Status is cancelled                                                                                                  |
|                                   |                     | 7         | CANCELLED_PARTIAL           | Order Status is cancelled partial. One or more of the order line items are cancelled or part of the quantity is cancelled |
| **c_externalReturnStatus**        | Custom              | 2         | CONFIRMED                   | Order Return is approved by the seller                                                                                     |
|                                   |                     | 3         | NEW                         | Order Return requested, not approved yet. When blind return, this status doesn’t exist                                    |
|                                   |                     | 4         | RETURNED                    | Order Return complete, the merchant/warehouse received the returned product                                                |
|                                   |                     | 5         | PARTIAL_RETURN              | Order Partial Return, some line items have been returned or partial quantity of a line item is returned                    |
|                                   |                     | 6         | CANCELLED                   | Order Return rejected by the seller                                                                                        |
|                                   |                     | 10        | PARTIAL_CONFIRMED           | Order Partial Approved by seller to return, some line items have been approved or partial quantity of a line item is approved |
| **shippingStatus**                | System              | 0         | SHIPPING_STATUS_NOTSHIPPED  | Shipping Status is Not shipped                                                                                             |
|                                   |                     | 1         | SHIPPING_STATUS_PARTSHIPPED | Shipping Status is Part Shipped                                                                                            |
|                                   |                     | 2         | SHIPPING_STATUS_SHIPPED     | Shipping Status is Shipped                                                                                                 |
| **c_cancelInfo**                  | Custom              |           |                             | Cancellation reason captured in a JSON blob                                                                                |

**ProductLineItem**
| **Field**                          | **Custom / System** | **Value** | **Display Value**           | **Description**                                                                  |
|------------------------------------|---------------------|-----------|-----------------------------|----------------------------------------------------------------------------------|
| **c_externalLineItemStatus**       | Custom              | 0         | SHIPPING_STATUS_NOTSHIPPED  | the products represented in the line item are not shipped                        |
|                                    |                     | 1         | SHIPPING_STATUS_PARTSHIPPED | partial quantity of the line item is shipped                                     |
|                                    |                     | 2         | SHIPPING_STATUS_SHIPPED     | the products represented in the line item are shipped                            |
|                                    |                     | 6         | CANCELLED                   | the products represented in the line item are cancelled                          |
|                                    |                     | 7         | CANCELLED_PARTIAL           | partial quantity of the line item has been cancelled                             |
| **c_externalLineItemReturnStatus** | Custom              | 1         | NEW                         | return requested, not approved yet. When blind return, this status doesn’t exist |
|                                    |                     | 2         | CONFIRMED                   | return is approved by the seller                                                 |
|                                    |                     | 3         | CANCELLED                   | return rejected by the seller                            
|                                    |                     | 4         | RETURNED                    | return complete, the merchant/warehouse received the returned product            |
|                                    |                     | 5         | PARTIAL_RETURN              | partial quantity of the line item has been returned                              |
|                                    |                     | 7         | PARTIAL_CANCELLED                   | partial quantity of the return line item has been rejected by the seller |
|                                    |                     | 10        | PARTIAL_CONFIRMED           | partial quantity of the line item has been approved to return by the seller      |

## Order Export Job
The `int_social_checkout` cartridge contains a job called `**{{SocialChannel}}-ExportOrderStatus**` which exports social channel orders and notifies the social channel when the export file is ready.

1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `{{SocialChannel}}-ExportOrderStatus` job
4. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run

## Salesforce Order Management
Salesforce Order Management contains an unmanaged package in the [social_oms_integration](../social_oms_integration) folder which updates order status (shipped, cancelled, etc) back to SFCC.

> Note: If you are using Salesforce Order Management please make sure a trust connection between SFCC and Salesforce Order Management has been established. Instructions for establishing this connection can be found in the following [guide](https://resources.docs.salesforce.com/latest/latest/en-us/sfdc/pdf/sfom_impl_b2ce.pdf#configure_storefront_integration), around page 12.

### Upload Salesforce Order Management Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_order_som`

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:oms` to upload the `int_order_som` cartridge to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

### Update Salesforce Order Management Cartridge Path
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridge listed below. Example path: `int_order_som:int_tiktok:int_social_checkout:int_socialfeeds:bc_library:app_storefront_base`
    - int_order_som

## Other Order Management Systems

### Upload Cartridges

> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_order_no_oms`

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:no_oms` to upload the `int_order_no_oms` cartridge to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

### Update Cartridge Path
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridge listed below. Example path: `int_order_no_oms:int_tiktok:int_social_checkout:int_socialfeeds:bc_library:app_storefront_base`
    - int_order_no_oms
