

# Export Inventory Lists

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Import Inventory Lists Data](#import-inventory-lists-data)
- [Sync Inventory](#sync-inventory)
  - [Review Job Configuration](#review-job-configuration)
</details>

## Import Inventory Lists Data

Inventory Lists data is found in [data/inventory_lists](../data/inventory_lists).

### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:inventory:lists`
    - This will zip, upload, and import the data files into the sandbox specified in your dw.json file.

### Option 2: Manually Zip, Upload, and Import via Business Manager
1. Zip the [data/inventory_lists](../data/inventory_lists) folder. From the root of the repo, run: `npm run data:inventory:lists:zip` (or manually zip the folder)
2. Log in to Business Manager
3. Go to **Administration** > **Site Development** > **Site Import & Export**
4. Click **Browse**
5. Select the `inventory_lists.zip` file from the root of the repo
6. Click **Upload**
7. Select `inventory_lists.zip`
8. Click **Import**
9. Click **OK**

## Sync Inventory

### Review Job Configuration
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `ExportInventoryLists` job
4. Click on the **Job Steps** tab and configure job steps
    - **ExportInventoryLists**
       - Configure `InventoryListIDs`. If the full list does not fit, create a duplicate job step and split the list.
       - Check `OverwriteExportFile`
       - **FileNamePrefix**: The step job will replicate the last modified file from the specified folder/directory. `src/feeds/export/social/google/inventory/inventory`
       - Click **Assign**
       - ![Google Export Inventory](../docs/images/biz-mngr-google-export-feeds-inventory-feed.png)
5. (Optional) If you need to have the generated inventory lists file in another folder for a different integration/channel, you can add and configure the `Custom.CopyLastModifiedFile` step job that allows copying the generated file to another location. This way, you only need to extract the list once and distribute copies of this file wherever necessary. This step job can be added to as many jobs as needed for different integrations
    - **originPath**: The step job will replicate the last modified file from the specified folder/directory. If no changes have been made to the imported "ExportInventoryLists" step job, use the following path: `src/feeds/export/social/google/inventory`
    - **destinationPath**: The destination folder where the step job will send the copied file (e.g: `src/feeds/export/social/instagram/inventory`)
    - Click **Assign**
    - ![Export Inventory Lists](../docs/images/biz-mngr-inventory-lists-copy-last-modified-file.png)
