# Facebook and Instagram Social Integration

## Table of Contents

<details open><summary>Click to open/close</summary>

- <details><summary>Facebook and Instagram Shop Ads Integration</summary>

    - [Facebook and Instagram Prerequisites](#facebook-and-instagram-prerequisites)
    - [Install Facebook and Instagram Dependencies](#install-facebook-and-instagram-dependencies)
    - [Install the Facebook and Instagram Cartridges](#install-the-facebook-and-instagram-cartridges)
    - [Update Facebook and Instagram Cartridge Paths](#update-facebook-and-instagram-cartridge-paths)
    - [Configure and Account Manager API Client ID and Secret](#configure-an-account-manager-api-client-id-and-secret)
    - [Import Facebook and Instagram Common and GLobal Data](#import-facebook-and-instagram-common-and-global-data)
    - [Configure Facebook and Instagram Business Manager Permissions](#configure-facebook-and-instagram-business-manager-permissions)
    - [Configure WebDAV Permissions](#configure-webdav-permissions)
    - [Configure Job Permissions](#configure-job-permissions)
    - [Configure SCAPI Hooks](#configure-scapi-hooks)
    - [Verify Environment Setup](#verify-environment-setup)
    - [Configure B2C Commerce for Facebook and Instagram](#configure-b2c-commerce-for-facebook-and-instagram)
        - [Salesforce B2C Commerce Configuration Details](#salesforce-b2c-commerce-configuration-details)
    - [Sync Product Catalog, Promotions, Shipping Profiles and Orders](#synchronize-the-product-catalog-promotions-shipping-profiles-and-orders)
        - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
        - [Configure and Schedule Jobs](#configure-and-schedule-jobs)
            - [Export Categories Job](#export-categories-job)
            - [Export Full Feeds Job](#export-full-feeds-job)
            - [Export Orders Job](#export-orders-job)
            - [Export Delta Feeds Job](#export-delta-feeds-job)
            - [Export Promotions Job](#export-promotions-job)
            - [Export Shipping Profiles Job](#export-shipping-profiles-job)
        - [Configure and Schedule Jobs for Multi-Site Environments](#configure-and-schedule-jobs-for-multi-site-environments)
        - [Facebook and Instagram Integration Best Practices](#facebook-and-instagram-integration-best-practices)
            - [Calculate Taxes When Using Hooks](#calculate-taxes-when-using-hooks)
            - [Manage Shopper Tracking Preferences](#manage-shopper-tracking-preferences)
            - [Manage Generated Feed Files](#manage-generated-feed-files)
            - [Replicate Code and Data From Staging](#replicate-code-and-data-from-staging)
        - [Upgrade Instagram Version](#upgrade-instagram-version)
        - [Disconnect Facebook and Instagram Integration](#disconnect-facebook-and-instagram-integration)
        - [Troubleshooting](#troubleshooting)

- <details><summary>Checkout Scenarios for Salesforce OMS</summary>

  - [Meta Transaction Flows](#checkout-scenarios-on-meta-flows)
    - [Cancelation of the Entire Order - Order Not Allocated](#1-shopper-requests-a-cancelation-of-the-entire-order---order-not-allocated)
    - [Cancelation of the Entire Order - Order Allocated](#2-shopper-requests-a-cancelation-of-the-entire-order---order-allocated)
    - [Cancelation of a Specific Line Item - Line Item Not Allocated](#3-shopper-requests-a-cancelation-of-a-specific-line-item---line-item-not-allocated)
    - [Cancelation of a Specific Line Item - Line Item Allocated](#4-shopper-requests-a-cancelation-of-a-specific-line-item---line-item-allocated)
    - [Cancelation of a Few Line Items - Some Items Allocated Some Not](#5-shopper-requests-a-cancelation-of-a-few-line-items---some-items-allocated-some-not)
    - [Return of an Entire Order - Seller Approves Return in OMS Manually](#6-shopper-requests-a-return-of-an-entire-order---seller-approves-return-in-oms-manually-in-development)
    - [Return of a Line Item - Seller Approves Return](#7-shopper-requests-a-return-of-a-particular-line-item---seller-approves-return-in-development)
    - [Return of an Entire Order - Seller Rejects Return](#8-shopper-requests-a-return-of-an-entire-order---seller-rejects-return-in-development)
    - [Return of a Line Item - Seller Rejects Return](#9-shopper-requests-a-return-of-a-line-item---seller-rejects-return-in-development)
    - [Return of an Entire Order - Seller Approves Refund no Need to Return the Products](#10-shopper-requests-a-return-of-an-entire-order---seller-approves-refund-no-need-to-return-the-products)
    - [Return of a Line Item - Seller Approves Refund no Need to Return the Product](#11-shopper-requests-a-return-of-a-line-item---seller-approves-refund-no-need-to-return-the-product)
    - [Return of an Entire Order - Seller Auto Approves Return on Facebook/Instagram or Manually Approve Return on Facebook/Instagram](#12-shopper-requests-a-return-of-an-entire-order---seller-auto-approves-return-on-instagram-or-manually-approve-return-on-instagram)
    - [Restocking fee of an product line item - SF OMS](#13-shopper-requests-a-restocking-fee-of-an-product-line-item---sf-oms)

  </details>
</details>

## Facebook and Instagram Shop Ads Integration

:warning: HEADS-UP! This integration does not support sites that use Gross Tax Policy. :warning:

Merchants can install and activate Facebook and Instagram assets (or connect to existing assets) using the [Meta Business Extension (MBE)](https://developers.facebook.com/products/business-apps/) tool.

The Facebook and Instagram module allows Commerce Cloud merchandisers to improve product discoverability and increase Commerce Cloud storefront traffic. It is is built from a set of Business Manager cartridges and is included in the [Social Channels Extension](https://github.com/SalesforceCommerceCloud/social_channel_integrations/social_channels). With this integration, you can:

1. Launch the [Meta Business Extension (MBE)](https://developers.facebook.com/products/business-apps/) tool from within Business Manager.
2. Install and connect to a new (or existing) asset to send data from their storefront to Facebook and Instagram.
3. Publish and sync an entire site catalog or a specific category of products into Facebook and Instagram, and apply catalog refreshes as frequently as every 15 minutes with no additional steps needed.
4. Publish the full category tree into Facebook and Instagram.
5. Synchronize promotions with Facebook and Instagram, so that Instagram shoppers can make use of the same promotions set up for your storefront.
6. Synchronize shipping profiles, so shoppers can place orders on Instagram using their shipping information from your storefront.
7. Synchronize orders and order statuses between Meta and Salesforce, so that the shopper can view and get accurate order updates from Meta.

### Facebook and Instagram Prerequisites
Before you integrate with Facebook and Instagram:

1. Ensure you have met the [SFCC Prerequisites](../README.md#prerequisites).
2. Create a [Meta Developer Account](https://developers.facebook.com/).
3. Optional: Create a [Meta Business Account](https://business.facebook.com/)
   - This step is optional because you can add your developer account to a pre-existing business account before starting the onboarding process.
4. Make sure you have:
    - A Salesforce Commerce Cloud site catalog
    - A Salesforce Commerce Cloud business user account

### Install Facebook and Instagram Dependencies
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Install Dependencies and Create dw.json](../README.md#install-dependencies-and-create-dwjson)

### Install the Facebook and Instagram Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. From the root of the `social_channel_integrations` repo, manually upload the following Facebook and Instagram cartridges using the instructions in [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges).

    - `int_social_base`: This cartridge contains code shared by all the social channels. Apply this cartridge to both the storefront and Business Manager cartridge paths.
    - `bm_socialchannels`: This cartridge contains the Business Manager controllers/UI logic for a new Business Manager extension that that integrates with Facebook and Instagram.
    - `int_instagram`: This cartridge contains the logic to integrate with Facebook and Instagram. It contains the service definitions, logic to handle the customer object that stores the Facebook and Instagram details, and the jobs that sync the B2C Commerce product categories, order, and so on with Facebook and Instagram.
    - `int_social_checkout`: This cartridge contains the logic to synchronize orders and order statuses between Facebook/Instagram and Salesforce.
    - `bc_library`: This library contains all shared code for various demandware community projects. Ported from [demandware-library](https://github.com/SalesforceCommerceCloud/demandware-library)
    - `bm_socialfeeds`: The custom feeds Business Manager module that allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model that ensures reasonable performance while more feeds are added. The extension comes with a Business Manager UI that is easy to use and does not require any technical background.
    - `int_socialfeeds`: The custom feeds module that allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model that ensures reasonable performance while more and more feeds are added.

> **NOTE**: In order to upload cartridges via npm scripts, you must replicate the dw.json in the `social_channels`, `social_checkout`, and `social_feeds` directories. The npm scripts attempt to create a symlink, but you  might need to manually create this symlink for your operating system.

### Update Facebook and Instagram Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Business Manager** cartridge path:
1. Log in to Business Manager.
2. Go to **Administration** > **Sites** > **Manage Sites**.
3. Within **Business Manager Site**, select the **Manage the Business Manager site** link.
4. Select the **Settings** tab.
5. In the **Cartridges** field, add paths for the following cartridges, for example: `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`.
    - `int_socialfeeds`
    - `bm_socialfeeds`
    - `bc_library`
    - `bm_socialchannels`
    - `int_social_base`
    - `int_instagram`
    - `int_social_checkout`

To update your **Site** cartridge path:
1. Log in to Business Manager.
2. Go to **Administration** > **Sites** > **Manage Sites**.
3. Select the site that you want to use, for example: site `RefArch`.
4. Select the **Settings** tab.
5. In the **Cartridges** field, add the following new cartridges so that they precede `app_storefront_base`. For example: `int_instagram:int_socialfeeds:int_social_checkout:bc_library:int_social_base:app_storefront_base`
    - `int_instagram`
    - `int_socialfeeds`
    - `int_social_checkout`
    - `bc_library`
    - `int_social_base`
    - `int_instagram`
    - `int_social_checkout`
6. Determine if you are using Salesforce OMS, and add the final required cartridge according to your environment:
  - `int_order_som` for Salesforce OMS users. The final path should look like: `int_order_som:int_instagram:int_socialfeeds:int_social_checkout:bc_library:int_social_base:app_storefront_base`.
  - `int_order_no_oms` for ***non*** Salesforce OMS users. The final path should look like: `int_order_no_oms:int_instagram:int_socialfeeds:int_social_checkout:bc_library:int_social_base:app_storefront_base`.

For details, see [OMS documentation](./oms.md#salesforce-order-management).

### Configure an Account Manager API Client ID and Secret

Meta uses the access token from the Account Manager (AM) client credentials to access feed files from Web-based Distributed Authoring and Versioning (WebDAV).

1. Create an Account Manager API Client ID for this integration using the instructions in [Create an API Client](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-admin-apis.html#create-an-api-client).
2. Ensure that you have the following required environments on ***Salesforce Commerce API*** role:
  ![Account Manager Allowed Scopes](./images/account-manager-commerce-api-role-scopes.png)
3. Add the following Allowed Scopes:
  - `sfcc.catalogs.rw`
  - `sfcc.orders.rw`
  - `sfcc.promotions`
  - `sfcc.promotions.rw`
    
  ![Account Manager Allowed Scopes](./images/account-manager-allowed-scopes.png)

### Import Facebook and Instagram Common and Global Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- To import Facebook and Instagram common data, perform the steps in [Import and Update Configuration Data -> Import Common Data](../README.md#white_check_mark-import-common-data).
- To import Facebook and Instagram global data:
  
  1. Zip the [data/instagram/instagram_global](../data/instagram/instagram_global) folder by running `npm run data:instagram:global:zip` from the root of the repo, or manually zipping up the folder. Pay attention to `data/instagram/instagram_global/sites/{SiteID}`, this should be your current site ID.
  2. Log in to Business Manager.
  3. Go to **Administration** > **Site Development** > **Site Import & Export**.
  4. Select **Browse**.
  5. Select the `instagram_global.zip` file from the root of the repo.
  6. Select **Upload**.
  7. Select `instagram_global.zip`.
  8. Select **Import**.
  9. Select **OK**.

### Configure Facebook and Instagram Business Manager Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager.
2. Go to **Administration** > **Organization** > **Roles & Permissions**.
3. Select the role of your Business Manager user(s).
4. Select the **Business Manager Modules** tab.
5. Select the specified Sites under **Sites**, for example: RefArch, RefArchGlobal.
6. Select **Apply**.
   
  ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
  
7. For **Custom Objects**, select the _write_ checkbox for `Custom Object Editor`.
   ![Custom Object Editor](../docs/images/biz-mngr-role-custom-object-editor.png)
8. For **Social Channels**, select the _write_ checkbox for `Facebook and Instagram`.
   ![Facebook and Instagram](../docs/images/biz-mngr-role-facebook-instagram.png)
9. Select **Update**.
10. In the **Business Manager Modules** tab, switch the context to **Organization**.
11. Select **Apply**.
    
   ![Select Context - Org](../docs/images/biz-mngr-select-context-org.png)
   
12. For **Operations**, select the _write_ checkbox for `Jobs`.
13. For **Operations**, select the _write_ checkbox for `Job History`.
   ![Job Permissions](../docs/images/biz-mngr-role-jobs.png)
14. For **Social Product Feeds**, select the _write_ checkbox for **Social Product Feeds Definition**.
    ![Social Product Feeds Definition](../docs/images/biz-mngr-role-social-product-feeds-definition.png)
15. Select **Update**.
16. Select the **WebDAV Permissions** tab.
17. Scroll to the **Impex** section.
18. Select the **Manage custom folders** link.
19. In the text box, enter: `src/feeds/export`.
    ![Manage custom folders](../docs/images/biz-mngr-role-webdav-manage-custom-folders.png)
20. Select **Apply**.
21. For **Impex**, select the _write_ checkbox for `/impex/src/feeds/export/*`.
    ![WebDAV Permissions](../docs/images/biz-mngr-role-webdav-permissions.png)
22. Select **Update**.

### Configure WebDAV Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

Follow the steps from [Configure WebDAV Permissions](../README.md#white_check_mark-configure-webdav-permissions).

### Configure Job Permissions
Use the same client ID from the previous step to add the following configuration to your sandbox OCAPI settings. Meta uses this permission information to trigger the product feed jobs when needed.

1. Log in to Business Manager.
2. Go to **Administration** > **Site Development** > **Open Commerce API Settings**.
3. Select `Data` in the `Select Type` field, and set the context as `Global (organization-wide)`.
  ![Select Data](../docs/images/data_settings_field.png)
4. Paste and merge the following configuration for your `clientID`:
```json
...
{
  "client_id": "<YOUR_CLIENT_ID>",
  "resources": [
    {
      "resource_id": "/jobs/*/executions",
      "methods": ["post"],
      "read_attributes": "(**)",
      "write_attributes": "(**)"
    }
  ]
}
...
```

For more information, refer to [Instagram Shopping with Commerce Cloud](https://resources.docs.salesforce.com/rel1/doc/en-us/static/pdf/Commerce_Cloud_Shopping_on_Instagram.pdf).

### Configure SCAPI Hooks

Enable SCAPI hook execution in Salesforce Commerce Cloud Business Manager so that you can create a basket or place an order through OCAPI endpoints when the access token is generated through SCAPI TSOB:

1. Go to **Administration** > **Global Preferences** > **Feature Switches**.
2. Check the `Enable Salesforce Commerce API Hook Execution` box.
   ![SCAPI hooks enabled](../docs/images/oci-scapi-hooks-enabled.png)
3. Select **Apply**.

Salesforce has implemented the following hooks:
  - [dw.ocapi.shop.basket.afterPATCH](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.afterPOST](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.modifyPOSTResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.coupon.modifyPOSTResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.items.modifyPOSTResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.coupon.modifyDELETEResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.item.modifyPATCHResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.shipment.shipping_address.modifyPUTResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.basket.shipment.shipping_method.modifyPUTResponse](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/basket/basket.js)
  - [dw.ocapi.shop.order.afterPATCH](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/order/orderPatch.js)
  - [dw.ocapi.shop.order.beforeGET](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/order/orderDetail.js)
  - [dw.order.calculateTax](../social_checkout/cartridges/int_social_checkout/cartridge/scripts/hooks/cart/calculate.js)

### Verify Environment Setup

Before continuing, verify that you have completed the required modifications to your environment:
  - The custom cartridges provided must be available inside your active code version
  - The Cartridge Path for ***Business Manager*** must be updated to include the required cartridges
    - `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`
  - The Cartridge Path for your current ***Site*** must be updated to include the required cartridges
    - for Salesforce OMS users: `int_order_som:int_instagram:int_socialfeeds:int_social_checkout:bc_library:int_social_base:app_storefront_base`
    - for ***non*** Salesforce OMS users: `int_order_no_oms:int_instagram:int_socialfeeds:int_social_checkout:bc_library:int_social_base:app_storefront_base`
  - The metadata ***system-objecttype-extensions*** file from ***data/common*** folder must be imported (`Basket`, `Order`, `ProductLineItem` and `ShippingLineItem` extensions)
  - The metadata ***custom-objecttype-definitions*** file from ***data/common*** folder must be imported (`SalesChannelFeedConfig` and `SocialChannels` definitions)
  - The metadata ***system-objecttype-extensions*** file from ***data/instagram/instagram_global*** folder must be imported (`Basket` and `Order` extensions like `Opt-In` attributes)
  - Permissions on `Administration > Organization > Roles & Permissions > Business Manager Modules (organization context)` to view the feed definition module in the required profiles must be configured
  - Permissions on `Administration > Organization > Roles & Permissions > Business Manager Modules (site context)` to view the onboarding module in the required profiles must be configured
  - Permissions on `Administration > Organization > Roles & Permissions > WebDAV Permissions` to WebDAV folders for the required profiles must be configured
  - Permissions on `Administration > Organization > WebDAV Client Permissions` to the integration Client ID access WebDAV folders must be configured
  - Permissions on `Administration > Site Development > Open Commerce API Settings` to the integration Client ID for jobs must be configured
  - The `Enable Salesforce Commerce API Hook Execution` on `Administration > Global Preferences > Feature Switches` must be checked to allow hook executions on basket and order requests
  - The payment method `META_SOCIAL_PAY` must be imported to your current site 
  - The custom object ***SalesChannelFeedConfig*** `instagram-feed` or a similar one must be imported and updated, to configure a feed template for your current site
  - The jobs on `Administration > Operations > Jobs`, `Instagram-ExportCategories`, `Instagram-ExportFullFeeds`, `Instagram-ExportOrders`, `Instagram-ExportPartialFeeds`, `Instagram-ExportPromotions` and `Instagram-ExportShippingProfiles` must be imported and configured, considering your current site ***scope*** and ***preferences*** (if you are using multisites, desired schedule, etc)
  - The services on `Administration > Operations > Services`, `facebook.graph` and `som.order.details` (if you are using SF OMS) must be imported.

### Configure B2C Commerce for Facebook and Instagram
1. Log in to Business Manager.
2. In Business Manager, go to **Merchant Tools** > **Social Channels** > **Facebook and Instagram**.
3. Select the **Accept Terms** button.
  ![Facebook and Instagram Accept Terms](../docs/images/facebook-instagram-accept-terms.png)
4. Fill out the form. If you need help, refer to the [onboarding configuration table](#salesforce-b2c-commerce-configuration-details) or select the small help icon for a field to learn about the required values.
  ![Facebook and Instagram Onboarding Form](../docs/images/biz-mngr-facebook-instagram-onboarding-form.png)
5. Select **Save**.
6. If all required fields are defined and valid, the **Onboarding** tab is displayed.
  ![Facebook and Instagram Onboarding Filled](../docs/images/biz-mngr-facebook-instagram-onboarding-filled.png)
7. Select **Get Started**.
  ![Facebook and Instagram Onboarding Splash](../docs/images/biz-mngr-facebook-instagram-onboarding-splash.png)
8. Login with your Facebook account (this should be part of a Meta Business Account)
  ![Facebook and Instagram Login](../docs/images/facebook-instagram-login.png)
9. Click **Continue as _[Your Name]_** to start the MBE flow:
  
  ![Facebook and Instagram Authorize](../docs/images/facebook-instagram-auth-business.png)
  
10. Select the following options from your Meta Business account:
  - Check **_Shops_** to configure the integration related to your Shop.
  - Check **_Facebook Ads_** to configure the integration related to your ad account.
    ![Facebook and Instagram Options](../docs/images/facebook-instagram-select-options.png)
11. Select the environment for this integration:
  - Choose ***Production*** if you want to be connected to your live assets
  - Choose ***Test*** if you want to validate this integration with test assets
    ![Facebook and Instagram Environment](../docs/images/facebook-instagram-environment.png)
12. Select a business **_Page_** from your Meta Business Account:
  - Connect to an _existing_ Page by selecting any entry you want to use.
  - Create a _new_ Page by clicking on **Create New** at the top of the list.
    ![Facebook and Instagram Assets](../docs/images/facebook-instagram-assets.png)
13. Choose an ***ad account*** if you checked this option on the first step. Otherwise, skip this step.
  - Connect to an _existing_ ad account by clicking on any entry you want to use.
  - Create a _new_ ad account by clicking on **Create New** at the top of the list.
    
    ![Facebook and Instagram Ad Account](../docs/images/facebook-instagram-ad-account.png)
    
14. Fill in the required ***Shop details***.
    
    ![Facebook and Instagram Shop Details](../docs/images/facebook-instagram-shop-details.png)
    
15. Confirm the commerce account being used and select **Next**.
    ![Product Catalog](../docs/images/facebook-instagram-confirm-account.png)
16. Check all required permissions for the Commerce Cloud application:
    
    ![Facebook and Instagram Permissions](../docs/images/facebook-instagram-permissions.png)
    
17. Select **Confirm** to perform the linking:
    
    ![Facebook and Instagram Linking](../docs/images/facebook-instagram-linking.png)
18. Set any additional desired additional information, or skip this step.
    ![Facebook and Instagram Additional](../docs/images/facebook-instagram-additional-info.png)
  - :warning: **Please wait for the onboarding to complete before closing or refreshing the page**
19. After completing the onboarding process, Commerce Cloud automatically attempts to share additional post onboarding data with Meta. If this fails, resend this information by selecting **Share Data**. If the automated process was executed successfully, **Share Data** not visible.
    ![Facebook and Instagram Share](../docs/images/biz-mngr-facebook-instagram-share.png)
20. When everything completes, check the connected Meta application details on Salesforce Commerce Cloud Business Manager. This information is used to process all features available in this integration.
  - `Business Manager ID`
  - `External Business ID`
    ![Facebook and Instagram Connected](../docs/images/biz-mngr-facebook-instagram-connected.png)
21. The new ***Meta*** tab contains information you need to manage your connection.
    ![Facebook and Instagram Connected Meta](../docs/images/biz-mngr-facebook-instagram-meta.png)

#### Salesforce B2C Commerce Configuration Details

| **Field Name**                          | **Details**                                                                                                                                                                                                                                                                                                                 |
|-----------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Salesforce AM Client ID**             | The Account Manager API Client ID, which is used for operations like accessing WebDAV folders to read feed files. (categories, products, and so on)                                                                                                                                                                                         |
| **Salesforce AM Client Secret**         | The Account Manager API Client Secret                                                                                                                                                                                                                                                                                       |
| **Salesforce SLAS ID**                  | The SLAS Credential ID, which is used for operations like syncing orders from Meta to Salesforce Commerce Cloud. To create a SLAS client, refer to the [Salesforce SLAS Client](./SLASClient.md).                                                                                                                                                                                                                      |
| **Salesforce SLAS Secret**              | The SLAS Credential Secret                                                                                                                                                                                                                                                                                                  |
| **Short Code**                          | The environment short code, which you can get by selecting the help icon or accessing _Administration > Site Development > Salesforce Commerce API Settings_.                                                                                                                                                     |
| **Organization ID**                     | The environment organization ID, which you can get by selecting the help icon or accessing _Administration > Site Development > Salesforce Commerce API Settings_.                                                                                                                                                 |
| **Current Site Hostname**               | The hostname used by the current site to access the environment APIs, for example: `dev.mysite.com`. This is important information, especially if this integration is running in a development or production instance. If you have a custom hostname registered, verify the correct value is in _Merchant Tools > SEO > Aliases_.         |
| **Product Feed Job ID**                 | The job ID used by the current Site to export full product feeds, for example: `Instagram-ExportFullFeeds`. This is used to trigger this job immediately after onboarding. If you have more than one storefront site, verify the correct job ID (according to the defined job step scope) is in _Administration > Operations > Jobs_. |

### Synchronize the Product Catalog, Promotions, Shipping Profiles, and Orders
Enable product catalog synchronization by reviewing catalog feed configuration and enabling the B2C Commerce job that sends the products to Facebook and Instagram. Other jobs perform synchronization for promotions, shipping profile information, and order status.

#### Review Catalog Feed Configuration

Catalog feed configurations are based on the [custom feeds module](https://github.com/SalesforceCommerceCloud/custom-feeds), which allows merchants to easily create catalog feeds according to their needs. After you define the template, you can schedule the feed to run at desired intervals. It is recommended to run this job at the same frequency you anticipate changes to your catalog, or whenever you replicate to production.

1. Log in to Business Manager.
2. Go to **Administration** > **Social Product Feeds** > **Social Product Feeds Definition**.

| **Field**                    | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Template**                 | The default feed configuration is loaded into the `instagram-feed` record within the **SalesChannelFeedConfig** custom object. Initial configuration is based on the SFRA reference website. Make sure you review the header and field mapping according to the catalog setup for your storefront and update it as required. Product field mappings can be found in [Social Product Feeds](./feedConfig.md). Possible areas of interest:  `imageJsonData type="large"`: configure proper image view type that should be exported `price type="usd-m-list-prices"`: configure the list pricebook |
| **Folder Name**              | `IMPEX/src/feeds/export/social/instagram/catalogs`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| **File Name**                | `instagram-feed-{{site_id}}-{{timestamp}}-{{locale}}.txt`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| **Category Specific Export** | The category to export. Enter `root` to export all products or enter a specific category, for example: `social-instagram`. Ensure the category you select is marked as "online".                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **Channel Type**             | `Instagram`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| **Google Shopping Category** | Category based on the kind of products that are sold on your site                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| **Available for Sites**      | The site(s) for which the products need to be exported. We recommend that you run and configure a feed template once per site. Custom object IDs can be defined in the `CustomObjectIds` job parameter within the **Product Full Feed** job step in the `Instagram-ExportFullFeeds` scheduled job.                                                                                                                                                                                                                                                                                                             |

#### Configure and Schedule Jobs

Review all job configurations, and then enable scheduling and execution according to your needs.

##### Export Categories Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the **Instagram-ExportCategories** job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Export Categories**
        - The following table shows important attributes:

        | **Step Parameter** | **Description**                                                                             |
        |--------------------|---------------------------------------------------------------------------------------------|
        | Is Disabled        | A flag to disable this step from the job execution flow (for test purposes)                 |
        | CatalogId          | The catalog ID for the catalog from which to extract the category tree. Use `*` for all catalogs.          |
        | Locale             | A specific locale for extracting category attributes or `ALL` to generate one file per locale |
        | FolderPath         | The folder in which to generate the feed. This path is relative to `_IMPEX/_`.                                                 |

        - Configure `CatalogId`.
        - Configure `Locale`.
        - Configure `FolderPath`.
        - Select **Assign**.
        
        ![Facebook and Instagram Export Category](../docs/images/biz-mngr-facebook-instagram-export-feeds-categories.png)
    - **Notify Feed**
        - Set **FeedType** to `PRODUCT_SETS`.
        - Set **UpdateType** to `CREATE`.
        - Set **FileFolder** to the folder location in which to generate the feeds. This path is relative to `_IMPEX/_`.
        - Select **Assign**.
        
        ![Facebook and Instagram Notify Category](../docs/images/biz-mngr-facebook-instagram-notify-feeds-categories.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

##### Export Full Feeds Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the `Instagram-ExportFullFeeds` job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Product Feed**
        - The following table shows important attributes:

        | **Step Parameter** | **Description**                                                                                                                                        |
        |--------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------|
        | Is Disabled        | A flag to disable this step from the job execution flow (for test purposes)                                                                            |
        | ExportCatalogs     | A flag to enable exporting products from catalogs. Set this to activated unless you want to generate only a delete feed file.                              |
        | Locales            | Comma-separated locales to extract product attributes. An empty value specifies only the default site locale.                                    |
        | GroupLocaleExport  | If checked, the product attributes are grouped by locales when generating the feeds.                                                                |
        | GenerateDeleteFeed | If checked, a delete feed is generated using the last feed execution information contained in tracking files. A separate file is created for deleted products, which informs Facebook and Instagram about products that are deleted. - **NOTE**: If you manually create a delete file for Facebook and Instagram, specify line endings as line feed, `LF` (`\n`) instead of carriage return `CR` (`\r`) or `CRLF` (`\r\n`). |
        | CustomObjectIds    | Comma separated SalesChannelFeedConfig IDs that store instructions on how to generate each feed, for example: `instagram-feed`.                                                     |
        | Hostname           | If informed, this composes the URL path of images on the resulting feed.                                                                 |
        - Check `ExportCatalogs`.
        - Check `GenerateDeleteFeed`.
        - Configure `CustomObjectIds`.
        - > :exclamation: This job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object.
        - Configure `Hostname`.
        - Select **Assign**.
        
        ![Facebook and Instagram Export Product](../docs/images/biz-mngr-facebook-instagram-export-feeds-product-full.png)
    - **Notify Feed**
        - Set **FeedType** to `PRODUCTS`.
        - Set **UpdateType** to `CREATE`.
        - Set **FileFolder** to the folder location in which to generate the feeds. This path is relative to `_IMPEX/_`.
        - Click **Assign**.
        
        ![Facebook and Instagram Notify Product](../docs/images/biz-mngr-facebook-instagram-notify-feeds-product-full.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

##### Export Orders Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the `Instagram-ExportOrders` job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Export Orders**
        - The following table shows important attributes:

        | **Step Parameter** | **Description**                                                             |
        |--------------------|-----------------------------------------------------------------------------|
        | Is Disabled        | A flag to disable this step from the job execution flow (for test purposes) |
        | FileFolder         | The folder in which to generate the feed file. This path is relative to `_IMPEX/_`.                                 |

        - Configure `FileFolder`.
        - Click **Assign**.
        
        ![Facebook and Instagram Export Order](../docs/images/biz-mngr-facebook-instagram-export-feeds-orders.png)
    - **Notify Feed**
        - Set **FeedType** to `ORDERS`.
        - Set **UpdateType** to `UPDATE`.
        - Set **FileFolder** to the folder location in which to generate the feeds. This path is relative to `_IMPEX/_`.
        - Select **Assign**.
        
        ![Facebook and Instagram Notify Order](../docs/images/biz-mngr-facebook-instagram-notify-feeds-orders.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

##### Export Delta Feeds Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the `Instagram-ExportPartialFeeds` job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Product Feed**
        - The following table shows important attributes:

        | **Step Parameter** | **Description**                                                                                                                                        |
        |--------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------|
        | Is Disabled        | A flag to disable this step from the job execution flow (for test purposes)                                                                            |
        | ExportCatalogs     | A flag to enable exporting products from catalogs. Set this to activated unless you want to generate only a delete feed file.                              |
        | DeltaCatalogInDays | Delta for a specified number of days. Valid values range from `0.1` to `1`. `0.1` = 2.4 hours; `0.2` = 4.8 hours;...; `1` = 24 hours. For example, set 0.1 to retrieve delta updated products for the last 2.4 hours.                                                                          |
        | Locales            | Comma-separated locales to extract product attributes. To retrieve only the default site locale, specify an empty value.                                    |
        | GroupLocaleExport  | If checked, the product attributes are grouped by locales when generating the feeds.                                                                |
        | GenerateDeleteFeed | If checked, a delete feed is generated using the last feed execution information contained in tracking files. A separate file is created for deleted products, which lets Facebook and Instagram know about products that are deleted. **NOTE**: If you manually create a delete file for Facebook and Instagram, specify line endings as line feed, `LF` (`\n`) instead of carriage return `CR` (`\r`) or `CRLF` (`\r\n`). |
        | CustomObjectIds    | Comma-separated `SalesChannelFeedConfig` IDs that store instructions on how to generate each feed, for example: `instagram-feed`.                                                     |
        | Hostname           | If informed, this is used to compose the URL path of images on the resulting feed.                                                                 |
        - Check `ExportCatalogs`.
        - Configure `DeltaCatalogInDays`.
        - Check `GenerateDeleteFeed`.
        - Configure `CustomObjectIds`.
        - > :exclamation: This job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object.
        - Configure `Hostname`.
        - Select **Assign**.
        
        ![Facebook and Instagram Export Delta](../docs/images/biz-mngr-facebook-instagram-export-feeds-product-delta.png)
    - **Notify Feed**
        - Set **FeedType** to `PRODUCTS`.
        - Set **UpdateType** to `UPDATE`.
        - Set **FileFolder** to the folder location for the feeds. This path is relative to `_IMPEX/_`.
        - Select **Assign**.
        
        ![Facebook and Instagram Notify Delta](../docs/images/biz-mngr-facebook-instagram-notify-feeds-product-delta.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

##### Export Promotions Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the `Instagram-ExportPromotions` job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Export Promotions**
        - The following table shows important attributes:

        | **Step Parameter**             | **Description**                                                                             |
        |--------------------------------|---------------------------------------------------------------------------------------------|
        | Export File                    | Optional. If used, the generated file receives the same name.             |
        | File Name Prefix (recommended) | A name prefix that can contain a path and is used to generate different files with a timestamp. This is the prefix for the file and folder where the feed is to be generated. This path is relative to `_IMPEX/src/_`. |
        | OverwriteExportFile            | If checked, the resulting file can overwrite an older file on the same directory.            |
        - Configure `FileNamePrefix`.
        - Click **Assign**.
        
        ![Facebook and Instagram Export Promotion](../docs/images/biz-mngr-facebook-instagram-export-feeds-promotions.png)
    - **Notify Feed**
        - Set **FeedType** to `PROMOTIONS`.
        - Set **UpdateType** to `CREATE`.
        - Set **FileFolder** to the folder location for the generated feeds. This path is relative to `_IMPEX/_`.
        - Select **Assign**.
        
        ![Facebook and Instagram Notify Promotion](../docs/images/biz-mngr-facebook-instagram-notify-feeds-promotions.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

##### Export Shipping Profiles Job

1. Log in to Business Manager.
2. Go to **Administration** > **Operations** > **Jobs**.
3. Select the `Instagram-ExportShippingProfiles` job.
4. Select the **Job Steps** tab and configure the following job steps:
    - **Export Shipping Methods**
        - The following table shows important attributes:

        | **Step Parameter**             | **Description**                                                                             |
        |--------------------------------|---------------------------------------------------------------------------------------------|
        | Export File                    | Optional. If used, the generated file receives the same name.             |
        | File Name Prefix (recommended) | A name prefix that can contain a path and be used to generate different files with a timestamp. This is the prefix for the file and folder where the feed is to be generated. This path is relative to `_IMPEX/src/_`. |
        | OverwriteExportFile            | If checked, the resulting file can overwrite an older file on the same directory.            |
        - Configure `FileNamePrefix`.
        - Click **Assign**.
        
        ![Facebook and Instagram Export Shipping](../docs/images/biz-mngr-facebook-instagram-export-feeds-shipping.png)
    - **Notify Feed**
        - Set **FeedType** to `SHIPPING_PROFILES`.
        - Set **UpdateType** to `CREATE`.
        - Set **FileFolder** to the folder location where the feeds are generated. This path is relative to `_IMPEX/_`.
        - Click **Assign**.
        
        ![Facebook and Instagram Notify Shipping](../docs/images/biz-mngr-facebook-instagram-notify-feeds-shipping.png)
5. Select **Run Now** or select the **Schedule and History** tab to schedule the job.

#### Configure Jobs for Multi-Site Environments

When you configure a job for more than one site, pay attention to the following job-specific information:

**Instagram-ExportCategories Job**

    - The **Export Categories** step generates the category tree feed and can create multiple files, depending on the selected locales.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
        - Create a sequential flow with the required steps.
        - Set a different folder for **Export Categories** and **Notify Feed**.
    
  ![Facebook and Instagram Export Category Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-categories-multi.png)
    
**Instagram-ExportFullFeeds Job**

    - The **Product Feed** step generates the catalog feed and can create multiple files, depending on the specified parameters.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
    
        - Create a sequential flow with the required steps.
        - Set a different `CustomObjectId` (a feed configuration id that includes folder and site) for **Product Feed** and a different folder for **Notify Feed**.
    
  ![Facebook and Instagram Export Product Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-product-full-multi.png)
    
**Instagram-ExportOrders Job**

    - The **Export Orders** step generates the order feed and creates just one file in the specified folder.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
    
        - Create a sequential flow with the required steps.
        - Set a different folder for **Export Orders** and **Notify Feed**.
    
  ![Facebook and Instagram Export Order Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-orders-multi.png)
    
**Instagram-ExportPartialFeeds Job**

    - The **Product Feed** step generates the catalog feed and can create multiple files, depending on the specified parameters.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
    
        - Create a sequential flow with the required steps.
        - Set a different CustomObjectId (a feed configuration id that includes folder and site) for **Product Feed** and a different folder for **Notify Feed**.
    
  ![Facebook and Instagram Export Delta Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-product-delta-multi.png)
    
**Instagram-ExportPromotions Job**

    - The **Export Promotions** step generates the promotion feed and creates just one file in the specified folder.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
    
        - Create a sequential flow for each site with the required steps.
        - Set a different folder for **Export Promotions** and **Notify Feed**.
    
  ![Facebook and Instagram Export Promotion Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-promotions-multi.png)
    
**Instagram-ExportShippingProfiles Job**

    - The **Export Shipping Methods** step generates the order feed and creates just one file in the specified folder.
    - The **Notify Feed** step attempts to send all files generated in the previous steps (observing the correct folder) to each site within the scope of this step.
    - For each site:
    
        - Create a sequential flow with the required steps.
        - Specify a different folder for **Export Shipping Methods** and **Notify Feed**.
    
  ![Facebook and Instagram Export Shipping Multi](../docs/images/biz-mngr-facebook-instagram-export-feeds-shipping-multi.png)

## Facebook and Instagram Integration Best Practices

### Calculate Taxes When Using Hooks

:warning: All tax calculations are provided by the Instagram integration. To avoid tax mismatches, especially when there are order-level promotions to be applied to a basket, the `dw.order.calculateTax` hook first checks the basket for the channel type 'instagramcommerce'. If the channel type 'instagramcommerce' is specified, the hook does not execute the 'basket.updateOrderLevelPriceAdjustmentTax' method and preserves the provided values. In the environment in which this cartridge is used, check this hook for any conflicts. If there are conflicts, you must ensure that the method is not executed in your custom code.

### Manage Shopper Tracking Preferences

The custom attribute `buyerMarketingEnabled` indicates a customer's choice for activity tracking and opting in to receive marketing communications.

For OCAPI requests, you must specify this attribute when the basket is created or updated, for example:

```json
{
    "c_buyerMarketingEnabled": <boolean>
}
``````

For SCAPI requests:

If you create or update a basket with a SCAPI request and then create an order with a checkout request, the rules for the attribute reflect the OCAPI configuration.

```json
{
  ...
  "c_buyerMarketingEnabled": <boolean>
  ...
}
``````

### Manage Generated Feed Files
Optional job steps can be added to any new or existing job to help manage the generated feed files. For details, see [Custom Feeds Delete](./feedConfig.md#custom-feeds-delete).

### Replicate Code and Data From Staging

When replicating *code* and *data* from staging:

1. Select the following options:

  - Code replication
    - Code version
  - Data replication
    - Global
      - Custom Object Types
      - OCAPI Settings
      - WebDAV Client Permissions
    - Site Specific
      - OCAPI Settings
      - Payment
2. Directly import the following objects to your target instance because they cannot be replicated:
  - Jobs
  - Services
3. Use the `Social Product Feeds Definition` module to create your ***SalesChannelFeedConfig*** custom object, or import the [sample provided](../data/instagram/instagram_global/custom-objects/SalesChannelFeedConfig.xml) and update with your site configuration.
4. Update your access roles to give permission to the new modules, for example: ***Social Feed Definition Screen*** and ***Onboarding Screen***.
5. Ensure that the ["Enable Salesforce Commerce API Hook Execution"](#configure-scapi-hooks) flag (`Administration > Global Preferences > Feature Switches`) is enabled.
6. Ensure that the Business Manager and Site Cartridge Paths are configured correctly.

## Meta Transaction Flows

The following image provides an overview of order-related Meta transactions involving Salesforce OMS on Salesforce B2C Commerce. Flow details are provided in the following sections.

  ![Facebook and Instagram Checkout Flow Overview](../docs/images/b2c_instagram_checkout_flow.png)

### 1. Shopper requests an entire order cancelation before ordered items are allocated

  ![Scenario 4](../docs/images/shooper-requests-a-cancelation-of-entire-order-order-not-allocated.png)

End-to-end test:

  ![New Order Business Manager](../docs/images/biz-mngr-facebook-instagram-new-order.png)

Result after sending the request to cancel the entire order:

  ![Cancel Entire Order](../docs/images/biz-mngr-facebook-instagram-canceled-entire-order.png)

Ordered items status updated on OMS:

  ![OMS Canceled Entire Order](../docs/images/oms-order-management-canceled-entire-order.png)

### 2. Shopper requests an entire order cancelation after ordered items are allocated

After items are allocated for an order, the order cannot be canceled:

  ![Scenario 5](../docs/images/shopper-requests-a-cancelation-of-the-entire-order-order-allocated.png)

### 3. Shopper requests a cancelation of a specific item before the item is allocated

  ![Scenario 6](../docs/images/shopper-requests-a-cancelation-of-a-specific-line-tem-line-item-not-allocated.png)

Result after sending the partial order cancelation request:

  ![Cancelation Of A Specific LineItem Order](../docs/images/biz-mngr-facebook-instagram-canceled-partially-order.png)

  ![Cancelation Of A Specific LineItem](../docs/images/biz-mngr-facebook-instagram-product-line-item-canceled-partial.png)

Result after sending the partial order cancelation request, indicating the total quantity of the item being canceled:


### 4. Shopper requests a cancelation of a specific line item after the item is allocated

After an item is allocated for an order, the order cannot be canceled. An error is returned:

  ![Cancelation Of A Specific LineItem Partially](../docs/images/biz-mngr-facebook-instagram-product-line-item-canceled-partial.png)

  ![Scenario 7](../docs/images/shopper-requests-a-cancelation-of-a-specific-line-item-line-item-allocated%20.png)

### 5. Shopper requests a cancelation of multiple items after some, but not all, items are allocated

After an item is allocated for an order, that item cannot be canceled. An error is returned for cancelation requests for allocated items:

  ![Scenario 8](../docs/images/shopper-requests-a-cancelation-of-a-few-line-items-some-items-allocated-some-not.png)

Result after sending the partial order cancelation request after some, but not all, items are allocated:

  ![Cancelation Of A Specific LineItem Order](../docs/images/biz-mngr-facebook-instagram-canceled-partially-order.png)

  ![Cancelation Of A Specific LineItem Partially](../docs/images/biz-mngr-facebook-instagram-product-line-item-canceled-partial.png)

Result after sending the partial order cancelation request, indicating the total quantity of the items being canceled:

  ![Cancelation Of A Specific LineItem Completed](../docs/images/biz-mngr-facebook-instagram-product-line-item-canceled.png)

Item status is updated on OMS for partial quantity cancellation:

  ![Cancelation Of A Specific LineItem Partially](../docs/images/biz-mngr-facebook-instagram-product-line-item-canceled-partial.png)

  ![OMS Canceled Items Not Allocated Some Not](../docs/images/oms-cancelation-of-a-few-line-items-some-items-allocated-some-not.png)

### 6. Shopper requests an entire order return - the seller manually approves the return in OMS (excluding shipment fees)

 ![Scenario 9](../docs/images/shopper-requests-a-return-o-an-entire-order-seller-approves-return-in-OMS-manually.png)

Result after order return is created for all line items and excluding shipping costs:

  ![Return Order exluding shipment](images/biz-mngr-facebook-instagram-product-line-item-partial-returned.png)

Item return status:

  ![biz-mngr-facebook-instagram-product-line-item-status-returned.png](images/biz-mngr-facebook-instagram-product-line-item-status-returned.png)

Item status on OMS after order return request is completed:

  ![oms-all-line-item-seller-approves-refund-no-need-to-return-the-product.png](images/oms-all-line-item-seller-approves-refund-no-need-to-return-the-product.png)

Result after order return is created for all line items and excluding shipping costs:

  ![Return Order exluding shipment](../docs/images/biz-mngr-facebook-instagram-canceled-partially-order.png)

### 7. Shopper requests a return for a specific item - the seller approves the return

  ![Scenario 10](../docs/images/shopper-requests-a-return-of-a-particular-line-item-seller-approves-return.png)

Order return status:

  ![biz-mngr-facebook-instagram-product-line-item-partial-returned.png](images/biz-mngr-facebook-instagram-product-line-item-partial-returned.png)

Item return status:

  ![biz-mngr-facebook-instagram-product-line-item-status-returned.png](images/biz-mngr-facebook-instagram-product-line-item-status-returned.png)

Item status after order return request is completed:

  ![oms-facebook-instagram-product-line-item-partial-returned.png](images/oms-facebook-instagram-product-line-item-partial-returned.png)

### 8. Shopper requests an entire order return - the seller rejects the return

  ![Scenario 11](../docs/images/shopper-requests-a-return-of-an-entire-order-seller-rejects-return.png)

Result of order return status:

  ![biz-mngr-facebook-instagram-product-line-order-cancelled.png](images/biz-mngr-facebook-instagram-product-line-order-cancelled.png)

Result of item status after return request is rejected:

  ![biz-mngr-facebook-instagram-product-line-item-status-cancelled.png](images/biz-mngr-facebook-instagram-product-line-item-status-cancelled.png)

### 9. Shopper requests a return of a line item - seller rejects return

  ![Scenario 12](../docs/images/shopper-requests-a-return-of-a-line-item-seller-reject-return.png)

Result of item status after return rejection:

  ![biz-mngr-facebook-instagram-product-line-item-status-cancelled.png](images/biz-mngr-facebook-instagram-product-line-item-status-cancelled.png)

Result of order status after return rejection:

  ![biz-mngr-facebook-instagram-product-line-order-cancelled.png](images/biz-mngr-facebook-instagram-product-line-order-cancelled.png)

OMS Status after return request rejected:

  ![oms-facebook-instagram-product-fulfilled.png](images/oms-facebook-instagram-product-fulfilled.png)

  ![oms-facebook-instagram-product-line-item-partial-returned.png](images/oms-facebook-instagram-product-line-item-partial-returned.png)

### 10. Shopper requests an entire order return - the seller approves a refund with no need to return the items

  ![Scenario 13](../docs/images/shopper-request-a-return-of-an-entire-order-seller-approves-refund-no-need-to-return-the-product.png)

Result after sending the refund request for the entire order:

  ![Refund Order No Need To Return The Product](../docs/images/biz-mngr-facebook-instagram-seller-approves-refund-no-need-to-return-the-product.png)

Item status is updated in B2C Commerce:

  ![OMS Refund Order No Need To Return The Product](../docs/images/oms-seller-approves-refund-no-need-to-return-the-product.png)

### 11. Shopper requests a return for a specific item - the seller approves a refund with no need to return the item

  ![Scenario 14](../docs/images/shopper-requests-a-return-of-a-line-item-seller-approves-refund-no-need-to-return-the-product.png)

Result after sending partial order refund request:

  ![Refund Order Line Item Seller Approves Refund No Need To Return The Product](../docs/images/biz-mngr-facebook-instagram-order-seller-approves-refund-no-need-to-return-the-product.png)

Item status is updated in B2C Commerce:

  ![Refund Line Item Seller Approves Refund No Need To Return The Product](../docs/images/biz-mngr-facebook-instagram-line-item-seller-approves-refund-no-need-to-return-the-product.png)

Item status is updated on OMS:

  ![OMS Refund Line Item Seller Approves Refund No Need To Return The Product](../docs/images/oms-line-item-seller-approves-refund-no-need-to-return-the-product.png)

### 12. Shopper requests an entire order return - the seller approves the return on Instagram (auto-approval or manual approval)

  ![Scenario 15](../docs/images/shopper-requests-a-return-of-an-entire-order-seller-auto-approves-return-on-instagram-or-manually-approve-return-on-instagram.png)

End-to-end test:
  ![Return Request Order Seller Auto Approves Return](../docs/images/biz-mngr-facebook-instagram-seller-auto-approves-return-on-instagram-or-manually-approve-return-on-instagram.png)

  ![OMS Return Request Order Seller Auto Approves Return](../docs/images/oms-seller-auto-approves-return-on-instagram-or-manually-approve-return-on-instagram.png)

  ![OMS RO Return Request Order Seller Auto Approves Return](../docs/images/oms-ro-seller-auto-approves-return-on-instagram-or-manually-approve-return-on-instagram.png)

### 13. Shopper incurs a restocking fee for a returned item - Salesforce OMS flow

  ![Scenario 13](../docs/images/shopper-requests-a-restocking-fee-of-an-product-line-item.png)

Result after return with restocking fee:

  ![biz-mngr-facebook-instagram-product-with-return-fee.png](images/biz-mngr-facebook-instagram-product-with-return-fee.png)

Item status is updated on OMS:

  ![oms-facebook-instagram-product-return-order-with-restocking-fee.png](images/oms-facebook-instagram-product-return-order-with-restocking-fee.png)

### 14.  Shopper requests shipping fee refund for a particular order

  ![Scenario 14](../docs/images/shopper-requests-refund-of-shipment.png)

Result after shipping fee refund:

  ![biz-mngr-facebook-instagram-shipment-refund.png](images/biz-mngr-facebook-instagram-shipment-refund.png)

Shipping fee adjustment in OMS:

  ![oms-facebook-instagram-product-shipment-refund.png](images/oms-facebook-instagram-product-shipment-refund.png)

### 15.  Shopper requests a discount on a particular item and related shipping costs

  ![Scenario 15](../docs/images/shopper-requests-discount-on-product-and-shipment.png)

Result after item and shipping fee refund:

  ![biz-mngr-facebook-instagram-product&shipment-refund.png](images/biz-mngr-facebook-instagram-product%26shipment-refund.png)

Adjustment in OMS:

  ![oms-facebook-instagram-product-refund.png](images/oms-facebook-instagram-product-refund.png)

### 16. Create a discount or appeasement in Salesforce OMS

  ![shopper-request-discount-on-product-via-narvar.png](images/shopper-request-discount-on-product-via-narvar.png)

Result after product and shipment refund:

  ![biz-mngr-facebook-instagram-product&shipment-refund.png](images/biz-mngr-facebook-instagram-product%26shipment-refund.png)

OMS shipment refund line item adjustment:

  ![oms-facebook-instagram-product-refund.png](images/oms-facebook-instagram-product-refund.png)

### 17. Initiate a return in Salesforce OMS that includes a restocking fee

  ![shopper-request-return-on-product-including-returnfee-via-narvar.png](images/shopper-request-return-on-product-including-returnfee-via-narvar.png)

End-to-end test:

Result after item return with restocking fee:

  ![biz-mngr-facebook-instagram-product-order-return-with-restockingfee.png](images/biz-mngr-facebook-instagram-product-order-return-with-restockingfee.png)

Return status with restocking fee in OMS:
  ![oms-facebook-instagram-product-return-with-restockingfee.png](images/oms-facebook-instagram-product-return-with-restockingfee.png)

### 18. Initiate a full refund, including shipping fees, in Salesforce OMS using Narvar (blind return)

  ![shopper-request-blind-return-on-product-no-returnfee-via-narvar.png](images/shopper-request-blind-return-on-product-no-returnfee-via-narvar.png)

Result after return using Narvar:

  ![biz-mngr-facebook-instagram-product-order-blind-return.png](images/biz-mngr-facebook-instagram-product-order-blind-return.png)

Order refund status in OMS, including shipping fee refund:

  ![oms-facebook-instagram-product-blind-return.png](images/oms-facebook-instagram-product-blind-return.png)

### 19. Salesforce OMS initiates order cancellation

  ![shopper-request-cancellation-via-SF-OMS.png](images/shopper-request-cancellation-via-SF-OMS.png)

Salesforce OMS result after cancellation flow:
  
  ![biz-mngr-facebook-instagram-canceled-entire-order.png](images/biz-mngr-facebook-instagram-canceled-entire-order.png)

OMS order status with shipment refund:

  ![oms-order-management-canceled-entire-order.png](images/oms-order-management-canceled-entire-order.png)

## Upgrade Instagram Version

To upgrade your ***social_channel_integration*** version:

1. See the instructions in the [main repository](https://github.com/SalesforceCommerceCloud/social_channel_integrations). These instructions include reuploading the required cartridges to your environment. 
2. Optional: Review the cartridge list in [Upload Facebook and Instagram Cartridges](#upload-facebook-and-instagram-cartridges).
3. Reimport the main metadata files:
    - data/common/meta/custom-objecttype-definitions.xml
    - data/common/meta/system-objecttype-extensions.xml
4. Reimport the metadata related to the current channel:
    - data/instagram/instagram_global/meta/system-objecttype-extensions.xml

***:warning: For new features, you might need to import additional settings such as services, jobs or permissions. In this cases, a change log is provided.***

## Disconnect Facebook and Instagram Integration
1. Log in to Business Manager.
2. In Business Manager, Go to **Merchant Tools** > **Social Channels** > **Facebook and Instagram**.
3. If you are connected, the **Disconnect** button is displayed.
   ![Facebook and Instagram Connected Status](../docs/images/biz-mngr-facebook-instagram-connected.png)
4. Selecting the **Disconnect** button calls the disconnect process and clears your data on this environment.
   ![Facebook and Instagram Disconnected](../docs/images/biz-mngr-facebook-instagram-disconnected.png)

## Troubleshooting
**Q: Why aren't my social integration hooks being executed?**
- A: If you implement the same hook in two or more cartridges, make sure you are not returning any status after finishing the execution of each hook. Otherwise, this can prevent subsequent hooks from running.

**Q: Why are Facebook/Instagram orders being created with `channelType = storefront` instead of `channelType = instagram`?**
- A: Make sure you added the `int_social_checkout` cartridge to your current site's cartridge path and your [SCAPI hooks are enabled](#configure-scapi-hooks).

**Q: Why is my product feed exporting an empty value for image columns?**
- A: The default type for images is large. If you don't have this image type specified for your products, specify an alternative value as provided in the main [feed config documentation](../docs/feedConfig.md#special-attributes).
