# Google Social Integration

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Google Installation Video](#google-installation-video)
- [Installation Instructions](#installation-instructions)
  - [Install Dependencies](#install-dependencies)
  - [Upload Cartridges](#upload-cartridges)
  - [Update Cartridge Paths](#update-cartridge-paths)
  - [Import Data](#import-data)
    - [Import Common Data](#import-common-data)
    - [Import Google Data](#import-google-data)
  - [Assign Business Manager Permissions](#assign-business-manager-permissions)
  - [Configure WebDAV Permissions](#configure-webdav-permissions)
  - [Service Configuration](#service-configuration)
- [Sync Product Catalog, Inventory, and Pricing](#sync-product-catalog-inventory-and-pricing)
  - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
  - [Review Job Configuration](#review-job-configuration)
    - [Export Full Feeds](#export-full-feeds)
- [Export Inventory Lists](#export-inventory-lists)
- [Omnichannel Inventory Integration](#omnichannel-inventory-integration)
- [Export Store Specific Pricing](#export-store-specific-pricing)
  - [Assign Price Books to a Specific Store](#assign-price-books-to-a-specific-store)
  - [Review Job Configuration](#review-job-configuration)
- [Configure Social Channels Integration](#configure-social-channels-integration)
- [Configure Google Checkout on Merchant](#configure-google-checkout-on-merchant)
  - [Permalinks](#permalinks)
    - [Updates to the Catalog Feed Configuration](#updates-to-the-catalog-feed-configuration)
    - [Include Permalinks with your Google Shoppings Feeds](#include-permalinks-with-your-google-shoppings-feeds)
  - [How To Install or Add on The Controller](#how-to-install-or-add-on-the-controller)
    - [Default Feature (merge behavior)](#default-feature-merge-behavior)
    - [Temporary Basket Feature (non-merge behavior)](#temporary-basket-feature-non-merge-behavior)
    - [Temporary Basket Definition](#temporary-basket-definition)
    - [The int_google_tempbasket_addon cartridge](#the-int_google_tempbasket_addon-cartridge)
    - [Controller conflicts](#controller-conflicts)
</details>

## Overview
The Google Channels integration is a turnkey solution that enables Salesforce Commerce Cloud merchants to list their store level or local products on Google Surfaces to improve discoverability of the products, and to drive foot traffic to their local stores.

The Salesforce Commerce Cloud (SFCC) social feeds cartridge built for Google Surfaces provides the following features:
1. Publish an entire site catalog, or a category of products into Google
2. Publish inventory information (either from the inventory lists imported into Commerce Cloud or directly from the Omnichannel Inventory (OCI) service) for all products for a site into Google
3. Publish list of stores (including the mapping to the inventory lists) to Google
4. Publish price books for products in each store to Google

## Prerequisites
To integrate with Google, please complete the following prerequisites:

1. Ensure you have met the required [SFCC Prerequisites](../README.md#prerequisites)
2. Create a [Google Merchant Account](https://www.google.com/retail/solutions/merchant-center)

## Google Installation Video
[![Google Installation Video](../docs/images/google-install-slide.jpg)](https://salesforce.vidyard.com/watch/9imcQvd85JvsGjctgt5gym)

## Installation Instructions

### Install Dependencies
1. Follow the steps from [Install Dependencies and Create dw.json](../README.md#install-dependencies-and-create-dwjson)

### Upload Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_social_base`: This cartridge contains code shared by all the social channels. It should be applied to both the storefront and Business Manager cartridge paths.
- `bm_socialchannels`: This cartridge contains the Business Manager controllers/UI logic to provide a new Business Manager extension that the site admin can use to integrate with Google.
- `int_google`: This cartridge contains the logic to integrate with Google.
- `int_google_checkout`: This cartridge is related to Google Permalinks and contains code to support this feature. :warning: Using this cartridge is mandatory if you are exporting product feeds using the [`googlecartpermalink`](./feedConfig.md#special-attributes) attribute.
- `int_google_tempbasket_addon`: This optional cartridge is also related to Google Permalinks and contains sample code to demonstrate how to use temporary baskets instead of the standard basket on the checkout process.
- `bc_library`: This library contains all shared code for various demandware community projects. Ported from [demandware-library](https://github.com/SalesforceCommerceCloud/demandware-library)
- `bm_socialfeeds`: The custom feeds Business Manager module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more feeds are added. The extension comes with a BM UI which is easily usable and does not require any technical background.
- `int_socialfeeds`: The custom feeds module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more and more feeds are added.

> **NOTE**: In order to upload cartridges via npm scripts, you will need to replicate the dw.json in the `social_channels`, `social_checkout`, and `social_feeds` directories. The npm scripts will attempt to create a symlink, but it might be necessary for you to manually create this symlink for your operating system.

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:google` to upload the `bm_socialchannels`, `int_google`, `int_google_checkout`, `bc_library`, `bm_socialfeeds`, and `int_socialfeeds` cartridges to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

### Update Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Business Manager** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Under **Business Manager Site**, click the `Manage the Business Manager site` link.
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`
    - int_socialfeeds
    - bm_socialfeeds
    - bc_library
    - bm_socialchannels
    - int_social_base

#### To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_google_checkout:int_google:int_socialfeeds:bc_library:int_social_base:app_storefront_base`
    - int_google_checkout
    - int_google
    - int_socialfeeds
    - bc_library
    - int_social_base
6. The cartridge `int_google_checkout` is related with Google Cart Permalinks and the checkout process. Please, note that if you are exporting product feeds using the [`googlecartpermalink`](./feedConfig.md#special-attributes) attribute, this cartridge will be mandatory.
7. There is an optional cartridge `int_google_tempbasket_addon` also related with Google Cart Permalinks and the checkout process. In this cartridge, all base endpoints used at checkout are modified to use temporary baskets instead of standard baskets when a shopper access the storefront through permalinks. Temporary baskets persist the products for about 15 minutes before deleted, therefore, standard baskets are not affected or changed on this interval. Sample path:
`int_google_tempbasket_addon:int_google_checkout:int_google:int_socialfeeds:bc_library:int_social_base:app_storefront_base`
    - int_google_tempbasket_addon
    - int_google_checkout
    - int_google
    - int_socialfeeds
    - bc_library
    - int_social_base


### Import Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

#### Import Common Data
1. Follow the steps from [Import and Update Configuration Data -> Import Common Data](../README.md#white_check_mark-import-common-data)

#### Import Google Data
Google Global data is found in [data/google/google_global](../data/google/google_global).

##### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:google:global`
    - This will zip, upload, and import the data files into the sandbox specified in your dw.json file.

##### Option 2: Manually Zip, Upload, and Import via Business Manager
1. Zip the [data/google/google_global](../data/google/google_global) folder. From the root of the repo, run: `npm run data:google:global:zip` (or manually zip the folder)
2. Log in to Business Manager
3. Go to **Administration** > **Site Development** > **Site Import & Export**
4. Click **Browse**
5. Select the `google_global.zip` file from the root of the repo
6. Click **Upload**
7. Select `google_global.zip`
8. Click **Import**
9. Click **OK**

### Assign Business Manager Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Administration** > **Organization** > **Roles & Permissions**
3. Select the role of your Business Manager user(s)
4. Click the **Business Manager Modules** tab
5. Select the specified Sites under **Sites** (e.g.: RefArch, RefArchGlobal)
6. Click **Apply**
    - ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
7. Under **Custom Objects**, select the _write_ checkbox for `Custom Object Editor`
    - ![Custom Object Editor](../docs/images/biz-mngr-role-custom-object-editor.png)
8. Under **Social Channels**, select the _write_ checkbox for `Google Channel`
    - ![Google Channel](../docs/images/biz-mngr-role-google-channel.png)
9. At the bottom of the screen, Click **Update**
10. At the top of **Business Manager Modules** tab, switch context to **Organization**
11. Click **Apply**
    - ![Select Context - Org](../docs/images/biz-mngr-select-context-org.png)
12. Under **Operations**, select the _write_ checkbox for `Jobs`
13. Under **Operations**, select the _write_ checkbox for `Job History`
     - ![Custom Object Editor](../docs/images/biz-mngr-role-jobs.png)
14. Under **Social Product Feeds**, select the _write_ checkbox for **Social Product Feeds Definition**
    - ![Social Product Feeds Definition](../docs/images/biz-mngr-role-social-product-feeds-definition.png)
15. At the bottom of the screen, Click **Update**
16. Click the **WebDAV Permissions** tab
17. Scroll to the **Impex** section
18. Click the **Manage custom folders** link
19. In the text box, enter: `src/feeds/export`
    - ![Manage custom folders](../docs/images/biz-mngr-role-webdav-manage-custom-folders.png)
20. Click **Apply**
21. Under **Impex**, select the _write_ checkbox for `/impex/src/feeds/export/*`
    - ![WebDAV Permissions](../docs/images/biz-mngr-role-webdav-permissions.png)
22. At the bottom of the screen, Click **Update**

### Configure WebDAV Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Configure WebDAV Permissions](../README.md#white_check_mark-configure-webdav-permissions)

### Service Configuration

1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Services**
3. On the **Services** tab, click `google.merchant.create`
4. Update **Credentials**:
   - For sandboxes, Development, and Staging, use `google-surfaces-api-preprod`
   - For Production, use `google-surfaces-api-prod`
5. Click **Apply**
6. Click **<< Back to List**
7. On the **Services** tab, click `google.merchant.get`
8. Update **Credentials**:
    - For sandboxes, Development, and Staging, use `google-surfaces-api-preprod`
    - For Production, use `google-surfaces-api-prod`
9. Click **Apply**

## Sync Product Catalog, Inventory, and Pricing

### Review Catalog Feed Configuration

Catalog feed configurations are based on the [custom feeds module](https://github.com/SalesforceCommerceCloud/custom-feeds) which allows merchants to easily create catalog feeds according to their needs. Once you define the template, you can schedule the feed to run at desired intervals. It is recommended to run this job at the same frequency you anticipate changes to your catalog, or whenever you replicate to production.

1. Log in to Business Manager
2. Go to **Administration** > **Social Product Feeds** > **Social Product Feeds Definition**

| **Field**                    | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Template**                 | The default feed configuration is loaded into the `google-shopping` record in the **SalesChannelFeedConfig** custom object. The initial configuration is based on the SFRA reference website. Review the header and field mapping according to the catalog setup for your storefront and update it as required. Product field mappings are found in [Social Product Feeds](./feedConfig.md). Possible areas of interest:<br/><ul><li>`imageJsonData type="large"`: configure proper image view type to be exported</li><li>`googleCartPermalink attributes="checkout,true"`: configure proper permalinks to be exported, for more details see the section [Special Attributes](./feedConfig.md#special-attributes). When using this feature, don't forget to add the cartridge [`int_google_checkout`](#upload-cartridges) to the site path, as it is required to support the generated permalink</li></ul> |
| **Folder Name**              | `IMPEX/src/feeds/export/social/google/product`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| **File Name**                | `google-shopping-{{site_id}}-{{timestamp}}-{{locale}}.txt`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| **Category Specific Export** | The category to export. Enter `root` to export all products or a specific category (e.g.: `social-google`). Ensure the category you select is marked as "online".                                                                                                                                                                                                                                                                                                                                                                                                  |
| **Channel Type**             | `Google`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| **Google Shopping Category** | Category based on the kind of products that are sold on your site                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| **Available for Sites**      | The site(s) for which the products need to be exported. It is recommended to run & configure a feed template once per site. Custom object IDs can be defined in the `CustomObjectIds` job parameter within the **ExportProductFullFeed** job step in the `Google-ExportFullFeeds` scheduled job.                                                                                                                                                                                                                                                                   |

### Review Job Configuration
#### Export Full Feeds
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `Google-ExportFullFeeds` job
4. Click on the **Job Steps** tab and configure job steps
    - **ExportPriceBook**
        - Configure `PriceBookID`.
        - Check `OverwriteExportFile`
        - **FileNamePrefix**: `feeds/export/social/google/pricebook/pricebook`
        - Click **Assign**
        - ![Google Export Pricing](../docs/images/biz-mngr-google-export-feeds-pricebook-feed.png)
    - **ExportStores**
      - **StoreID**: Define the ID of the store to be exported or `*` to export all stores
      - **FileNamePrefix**: `feeds/export/social/google/stores/store`
      - Check `OverwriteExportFile`
      - Click **Assign**
      - ![Google Export Stores](../docs/images/biz-mngr-google-export-feeds-store-feed.png)
    - **ExportProductFullFeed**
        - Check `ExportCatalogs`
        - Check `GenerateDeleteFeed`
          - There will be a separate file created for deleted products.
        - Configure `CustomObjectIds`, comma separated custom object IDs used to build a feed (e.g.: `google-shopping`)
        - > :exclamation: Please, note that this job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object
        - Configure `Hostname`
        - Click **Assign**
        - ![Google Export Product](../docs/images/biz-mngr-google-export-feeds-product-full-feed.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run
...
## Export Inventory Lists
**Export Inventory Lists**: If you are NOT using Omnichannel Inventory complete the steps from [inventoryLists](./inventoryLists.md).

## Omnichannel Inventory Integration
In case the storefront has [Omnichannel Inventory](https://help.salesforce.com/s/articleView?id=cc.b2c_inventory_management_omnichannel_inventory.htm) enabled, the native inventory export won't generate accurate inventory.

Please complete the steps from the [Omnichannel Inventory Integration](./oci.md) document. After doing so, remove the standard inventory export from the **Google-ExportFullFeeds** job (if you uploaded the data about inventory_lists):
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the trash can icon associated with the `ExportInventoryLists` job to delete it.

## Export Store Specific Pricing
To export store specific pricing, assign price books to stores using the [assignments framework](https://help.salesforce.com/s/articleView?id=cc.b2c_assigning_a_pricebook_or_promotion_to_a_specific_store.htm). Once assignments have been imported, you can use the `Google-StorePricingExport` job to export store specific price books to Google.

### Assign Price Books to a Specific Store
1. Log in to Business Manager
2. Go to **Merchant Tools** > **Online Marketing** > **Import & Export**
3. Click **Upload** to upload an assignments.xml file
   - <details><summary>Sample assignments.xml</summary>

     - ```xml
       <?xml version="1.0" encoding="UTF-8"?>
       <assignments xmlns="http://www.demandware.com/xml/impex/assignment/2020-11-30">
           <assignment assignment-id="german_store">
               <enabled-flag>true</enabled-flag>
               <start-date>2020-11-24T00:00:00.000Z</start-date>
               <end-date>2030-11-24T00:00:00.000Z</end-date>
               <assigned-sites>
                   <site>RefArch</site>
                   <site>RefArchGlobal</site>
               </assigned-sites>
               <qualifiers match-mode="any">
                   <qualifier type="Store">german_store</qualifier>
               </qualifiers>
               <experiences>
                   <pricebooks>
                       <pricebook-id>eur-m-list-prices</pricebook-id>
                       <pricebook-id>eur-m-sale-prices</pricebook-id>
                   </pricebooks>
                </experiences>
           </assignment>

           <assignment assignment-id="store1">
               <enabled-flag>true</enabled-flag>
               <start-date>2020-11-24T00:00:00.000Z</start-date>
               <end-date>2030-11-24T00:00:00.000Z</end-date>
               <assigned-sites>
                   <site>RefArch</site>
                   <site>RefArchGlobal</site>
               </assigned-sites>
               <qualifiers match-mode="any">
                   <qualifier type="Store">store1</qualifier>
               </qualifiers>
               <experiences>
                   <pricebooks>
                       <pricebook-id>usd-m-list-prices</pricebook-id>
                       <pricebook-id>usd-m-sale-prices</pricebook-id>
                   </pricebooks>
               </experiences>
           </assignment>
        </assignments>
        ```

4. Click **Import** in the Assignments section
</details>

### Review Job Configuration
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `Google-StorePricingExport` job
4. Click on the **Job Steps** tab and configure job steps
    - **ExportAssignments**
        - **ExportFile**: `feeds/export/social/google/assignments/assignments`
        - Check `OverwriteExportFile`
        - Click **Assign**
        - ![Google Export Assignments](../docs/images/biz-mngr-google-export-assignments.png)
    - **GoogleLIA Store Pricing Export**
        - **FolderPath**: `feeds/export/social/google`
        - Check `OverwriteExportFile`
        - Click **Assign**
        - ![Google Store Pricing Export](../docs/images/biz-mngr-google-export-store-pricing.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run

## Configure Social Channels Integration
1. Log in to Business Manager
2. Ensure you have successfully run the `Google-ExportFullFeeds` at least once. The feeds need to exist in the WebDAV folder at: `/webdav/Sites/Impex/src/feeds/export/social/google/`, or on your customized directory
3. In Business Manager, Go to **Merchant Tools** > **Social Channels** > **Google Channel**
4. Click **Accept Terms** button
    - ![Google Accept Terms](../docs/images/google-accept-terms.png)
5. Refer to the [onboarding configuration table](#google-onboarding-configuration-table) for help in filling out the form
    - ![Google Onboarding Form](../docs/images/biz-mngr-google-onboarding-form.png)
6. Select **Submit**

### Google Onboarding Configuration Table

| **Field Name**                                  | **Details**                                                                                                                                     |
|-------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------|
| **Name**                                        | Name for the business user                                                                                                                      |
| **Email**                                       | Email for the business user                                                                                                                     |
| **Country Calling Code**                        | Country calling code for the phone number of the business user                                                                                  |
| **Phone**                                       | Phone number of the business user                                                                                                              |
| **Account Manager Client ID**                   | The Account Manager Client ID you set up in Account Manager                                                                                     |
| **Account Manager Client Secret**               | The secret/password for your Client ID above                                                                                                    |
| **Org ID**                                      | Salesforce Commerce API Org ID. Found at Administration > Site Development > Salesforce Commerce API Settings (e.g.: `f_ecom_abcd_123`)         |
| **Google Merchant Center ID**                   | Go to Google Merchant Center, find your merchant ID, which is the number at the top-right corner of the page, above the account email address   |

## Configure Google Checkout on Merchant
Google Checkout on Merchant enables shoppers to get redirected to a site's Cart or Checkout page with a product already added to the basket, when they click on a cart icon from Google Shopping search results. 

To support this process, there are two features provided by this integration:
- Permalink generation on product feeds
- A new controller to read the generated links

### Permalinks

A permalink is the URL generated on product feed files for Google integration and has the following format:

`https://<**realm-instance**>.dx.commercecloud.salesforce.com/on/demandware.store/Sites-<**site id**>-Site/default/Google-Cart/<**product id**>:<**quantity**>?checkout=<**true|false**>`

Use the **checkout** action to redirect shoppers to the **Checkout** (`checkout=true`) or **Cart** (`checkout=false`) page.

#### Updates To The Catalog Feed Configuration

To add permalinks, the `SalesChannelFeedConfig` used to export product feeds should be updated.

#### Include Permalinks with your Google Shoppings Feeds

Include the parameter `googleCartPermalink attributes="checkout,true"` in the feed template configuration (`google-shopping`). When the export job completes, the permalink will be added for each product.

##### Configuring product quantities
When generating permalinks, the URL default `quantity` to be added on a shopper basket is `1`, however, this value can be different depending on each product `minOrderQuantity` (***Minimum Order Quantity***).

- ![google-shopping](../docs/images/biz-mngr-google-social-feeds-definition.png)

No action is required if the custom object [SalesChannelFeedConfig](../data/google/google_global/custom-objects/SalesChannelFeedConfig.xml) has been imported. For more details, see [Special Attributes](./feedConfig.md#special-attributes).

The product permalink URLs will then be included in the google product feed like below:

- ![google-shopping-product-feed](../docs/images/google-shopping-product-feed.png)

About the new controller, use the `Google-Cart` endpoint included in `int_google_checkout` cartridge to read these requests that add products and quantities to a storefront basket.

For example, `https://abcd-123.dx.commercecloud.salesforce.com/on/demandware.store/Sites-RefArch-Site/default/Google-Cart/008884304016M:1?checkout=true` will add products to the cart and redirect shoppers to the checkout page. When the order is complete, it will have `ChannelType = Google`.

### How To Install or Add on the Controller

Access the [link](#to-update-your-site-cartridge-path) for more information about related cartridges. Check the differences between the available controllers.

#### Default Feature (merge behavior)

The [`Google.js`](/social_channels/cartridges/int_google_checkout/cartridge/controllers/Google.js) controller in `int_google_checkout` cartridge supports the permalinks through the new `Cart` endpoint merging products. The product included in the URL action is added to the current site basket.

![checkout-google-cart-current-basket-permalinks](../docs/images/checkout-google-cart-current-basket-permalinks.png)

If any product is already included in the current site basket, it will be merged with the products added by permalinks.

#### Temporary Basket Feature (non-merge behavior)

The [`Google.js`](/social_channels/cartridges/int_google_tempbasket_addon/cartridge/controllers/Google.js) controller in `int_google_tempbasket_addon` cartridge supports the permalinks through the new `Cart` endpoint separating products. The product included in the URL action is added to a temporary basket.

![checkout-google-cart-temporary-basket-permalinks](../docs/images/checkout-google-cart-temporary-basket-permalinks.png)

Therefore, products added by [permalinks](#permalinks) with `int_google_tempbasket_addon` cartridge installed are not merged with products already added to the site's standard basket.

#### Temporary Basket Definition

The temporary basket is a [system feature](https://salesforcecommercecloud.github.io/b2c-dev-doc/docs/current/scriptapi/html/index.html?target=class_dw_order_BasketMgr.html). As temporary baskets are separate from shopper storefront and agent baskets, customers use temporary baskets to perform calculations or create an order without disturbing an open storefront basket. Temporary baskets have a 15 minute lifetime, and are automatically deleted when they expire (restoring all products previously added in this process).
By default only 4 open temporary baskets are allowed per customer. If the limit is exceeded, an internal flow control in the feature deletes the first temporary basket on queue, and replaces it with a new one.

#### The [int_google_tempbasket_addon](/social_channels/cartridges/int_google_tempbasket_addon/) Cartridge

This optional cartridge related to Google Permalinks contains sample code that demonstrate how to use temporary baskets instead of the standard basket on the checkout process.

![vs-code-int-google-checkout-cartridge-controllers](../docs/images/vs-code-int-google-checkout-cartridge-controllers.png)

If you need the *non-merge* behavior, use this code to understand how to implement temporary baskets.

In the implementation provided, if a project is using the cartridge **int_google_tempbasket_addon** and a shopper opens a permalink, their current standard basket will be stored (along with any products previously added), and a temporary basket will be activated (containing the product parameterized on the permalink). From that point, any product added by the shopper will be inserted into the temporary basket (so as not to confuse the shopper, as if we do otherwise, the products will be added to a hidden basket - the standard basket), and this behavior will persist until:

* the shopper places an order
* the temporary basket expires ([expiration time is 15min](https://salesforcecommercecloud.github.io/b2c-dev-doc/docs/current/scriptapi/html/api/class_dw_order_BasketMgr.html#dw_order_BasketMgr_createTemporaryBasket_DetailAnchor))

After one of those events, the standard basket is restored with all previous content.

As this is not a native feature, this behavior is provided through custom code. To achieve that, we need to control which basket is used after a permalink is opened, so the cartridge **int_google_tempbasket_addon** provides different controllers to replace any process that load/change the basket content.

As there are common controllers in this sample, check if the provided code can conflict with your current implementation.

#### Controller Conflicts

Each controller in the following table can be present on multiple cartridges when a customer has already customized it. If the file exists only in the **app_storefront_base** cartridge and in this addon cartridge, the addon controller overrides the base controller, but the presence of a controller file in additional cartridges (e.g.: **app_mysite_base**) indicates a conflict that you have to resolve in a customization cartridge. However, if you are using only one of the conflicting files, no action is necessary.

| **Controller**           | **Action**                | **Location**                                                                  |
|--------------------------|---------------------------|-------------------------------------------------------------------------------|
| Cart                     | AddBonusProducts          | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | AddCoupon                 | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | AddProduct                | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | EditBonusProduct          | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | EditProductLineItem       | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | Get                       | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | GetProduct                | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | MiniCart                  | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | MiniCartShow              | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | RemoveCouponLineItem      | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | RemoveProductLineItem     | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | SelectShippingMethod      | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | Show                      | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
|                          | UpdateQuantity            | int_google_tempbasket_addon/cartridge/controllers/Cart.js                     |
| Checkout                 | Begin                     | int_google_tempbasket_addon/cartridge/controllers/Checkout.js                 |
| CheckoutAddressServices  | AddNewAddress             | int_google_tempbasket_addon/cartridge/controllers/CheckoutAddressServices.js  |
|                          | CreateNewAddress          | int_google_tempbasket_addon/cartridge/controllers/CheckoutAddressServices.js  |
| CheckoutServices         | Get                       | int_google_tempbasket_addon/cartridge/controllers/CheckoutServices.js         |
|                          | LoginCustomer             | int_google_tempbasket_addon/cartridge/controllers/CheckoutServices.js         |
|                          | PlaceOrder                | int_google_tempbasket_addon/cartridge/controllers/CheckoutServices.js         |
|                          | SubmitCustomer            | int_google_tempbasket_addon/cartridge/controllers/CheckoutServices.js         |
|                          | SubmitPayment             | int_google_tempbasket_addon/cartridge/controllers/CheckoutServices.js         |
| CheckoutShippingServices | SelectShippingMethod      | int_google_tempbasket_addon/cartridge/controllers/CheckoutShippingServices.js |
|                          | SubmitShipping            | int_google_tempbasket_addon/cartridge/controllers/CheckoutShippingServices.js |
|                          | ToggleMultiShip           | int_google_tempbasket_addon/cartridge/controllers/CheckoutShippingServices.js |
|                          | UpdateShippingMethodsList | int_google_tempbasket_addon/cartridge/controllers/CheckoutShippingServices.js |
| Order                    | Confirm                   | int_google_tempbasket_addon/cartridge/controllers/Order.js                    |
| Page                     | SetLocale                 | int_google_tempbasket_addon/cartridge/controllers/Page.js                     |

:green_book: The addition on every controller is focused on selecting the right basket to process each request, so instead of **getCurrentOrNewBasket** we have **getCurrentSocialBasket** on this addon cartridge.