# Create a Shopper Login and API Access Service (SLAS) Client

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Overview](#overview)
- [Required Scopes](#required-scopes)
- [Create Shopper Client using the SLAS Admin UI](#option-1---create-shopper-client-using-the-slas-admin-ui)
- [Create Shopper Client using the SLAS Admin API](#option-2---create-shopper-client-using-the-slas-admin-api)
  - [Get a SLAS Admin Token](#get-a-slas-admin-token)
    - [Use an Account Manager API Client to interact with the SLAS Admin API](#use-an-account-manager-api-client-to-interact-with-the-slas-admin-api)
  - [Set Environment Variables](#set-environment-variables)
  - [Create SLAS Private Client](#create-slas-private-client)
- [OCAPI Settings for SLAS Clients (Facebook & Instagram Only)](#ocapi-settings-for-slas-clients-facebook--instagram-only)
- [Additional Information](#additional-information)

</details>

## Overview
Where noted in the channel specific documentation, you will need to create a SLAS **_Private_** Shopper client ID and secret. This client will need to have the `sfcc.ts_ext_on_behalf_of` scope.

> Note: Not all channels require a SLAS client ID and secret. Refer to your channel specific documentation ([Google](./google.md), [Instagram](./instagram.md), [Snapchat](./snapchat.md), [TikTok](./tiktok.md)) to determine if this step is required for your implementation.

## Required Scopes
Listed below are the required scopes you will need to add in your SLAS client ID. Refer to the [Scopes Catalog](https://developer.salesforce.com/docs/commerce/commerce-api/guide/auth-z-scope-catalog.html) for additional information.
- `sfcc.orders.rw`
- `sfcc.shopper-baskets-orders`
- `sfcc.shopper-baskets-orders.rw`
- `sfcc.shopper-categories`
- `sfcc.shopper-customers.login`
- `sfcc.shopper-customers.register`
- `sfcc.shopper-gift-certificates`
- `sfcc.shopper-myaccount`
- `sfcc.shopper-myaccount.addresses`
- `sfcc.shopper-myaccount.addresses.rw`
- `sfcc.shopper-myaccount.baskets`
- `sfcc.shopper-myaccount.orders`
- `sfcc.shopper-myaccount.paymentinstruments`
- `sfcc.shopper-myaccount.paymentinstruments.rw`
- `sfcc.shopper-myaccount.productlists`
- `sfcc.shopper-myaccount.productlists.rw`
- `sfcc.shopper-myaccount.rw`
- `sfcc.shopper-product-search`
- `sfcc.shopper-productlists`
- `sfcc.shopper-products`
- `sfcc.shopper-promotions`
- `sfcc.ta_ext_on_behalf_of`
- `sfcc.ts_ext_on_behalf_of`

![SLAS Scopes](./images/slas-scopes.png)

## Create Shopper Client
There are two methods for creating the SLAS client and secret, either via SLAS Admin UI or SLAS Admin API. Choose one for the creation:

### Option 1 -  Create Shopper Client using the SLAS Admin UI
The easiest way to create a SLAS client is to use the SLAS Admin UI. Refer to the following [documentation](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-shopper-apis.html) for instructions on setting up your private client ID and Secret via the SLAS Admin UI.

### [Option 2 - Create Shopper Client using the SLAS Admin API](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-shopper-apis.html#advanced-slas-admin-api)
The [SLAS Admin API](https://developer.salesforce.com/docs/commerce/commerce-api/references/slas-admin?meta=Summary) offers an alternative to the SLAS Admin UI that makes it easier to automate SLAS administration tasks, such as creating public and private clients. The API also allows you to access a wider range of configuration options.

#### Get a SLAS Admin Token
To access the SLAS Admin API, you will need to get an admin token. You can do this in the following ways:

1. Use the [SLAS Admin UI to get an admin token](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-shopper-apis.html#get-a-slas-admin-token)
2. Use [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci):
```shell
sfcc-ci auth:login
sfcc-ci client:auth:token
```
> Note: When using this option, you will need to ensure the user has the proper roles and permissions outlined in the [documentation](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-shopper-apis.html#set-up-user-roles-and-filters).
3. [Use an Account Manager API Client to interact with the SLAS Admin API](#use-an-account-manager-api-client-to-interact-with-the-slas-admin-api)

##### Use an Account Manager API Client to interact with the SLAS Admin API
Refer to the [installation video](https://share.vidyard.com/watch/WmrMwPsf1G1MtBKAmisQPC?second=242) for a demonstration on configuring an Account Manager API Client to interact with the SLAS Admin API.

1. Create an [API Client ID and Secret](https://help.salesforce.com/s/articleView?id=cc.b2c_account_manager_add_api_client_id.htm) in Account Manager.
2. In the `Roles` Section, under `Commerce Cloud Developer Experience` > add `Sandbox API User` > ensure the filter includes all relevant instances:<br/>
   ![Account Manager Client ID](./images/client-api-user.png)
3. Set **Default Scopes** to:
```txt
mail
roles
tenantFilter
profile
openId
```
4. Set **Token Endpoint Auth Method** to `client_secret_post`
5. Set **Access Token Format** to `JWT`

#### [Set Environment Variables](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-shopper-apis.html#set-environment-variables)
Refer to [Configuration Values](https://developer.salesforce.com/docs/commerce/commerce-api/guide/commerce-api-configuration-values.html)
```shell
export "SFCC_ACCESS_TOKEN={{clipboard_contents}}"
export "SFCC_REALM_ID=zzte"
export "SFCC_INSTANCE_ID=053"
export "SFCC_SCAPI_TENANTID=${SFCC_REALM_ID}_${SFCC_INSTANCE_ID}"
export "SFCC_SCAPI_SHORTCODE=kv7kzm78"
export SLAS_CLIENT_ID=f58d60fd-9230-4ed7-90a4-ee11b5e7f27b
export SLAS_CLIENT_SECRET=D*HHUrgO2%qADp2JTIUi
```

#### Create SLAS Private Client
```shell
curl "https://$SFCC_SCAPI_SHORTCODE.api.commercecloud.salesforce.com/shopper/auth-admin/v1/tenants/$SFCC_SCAPI_TENANTID/clients/$SLAS_CLIENT_ID" \
--location --request 'PUT'  \
--header 'Content-Type: application/json' \
--header "Authorization: Bearer $SFCC_ACCESS_TOKEN" \
--data-raw '{
    "clientId": "'"$SLAS_CLIENT_ID"'",
    "secret": "'"$SLAS_CLIENT_SECRET"'",
    "isPrivateClient": true,
    "name": "Social Channels Private Client",
    "channels": [
        "RefArch",
        "RefArchGlobal"
    ],
    "scopes": [
        "sfcc.orders.rw",
        "sfcc.shopper-baskets-orders",
        "sfcc.shopper-baskets-orders.rw",
        "sfcc.shopper-categories",
        "sfcc.shopper-customers.login",
        "sfcc.shopper-customers.register",
        "sfcc.shopper-gift-certificates",
        "sfcc.shopper-myaccount",
        "sfcc.shopper-myaccount.addresses",
        "sfcc.shopper-myaccount.addresses.rw",
        "sfcc.shopper-myaccount.baskets",
        "sfcc.shopper-myaccount.orders",
        "sfcc.shopper-myaccount.paymentinstruments",
        "sfcc.shopper-myaccount.paymentinstruments.rw",
        "sfcc.shopper-myaccount.productlists",
        "sfcc.shopper-myaccount.productlists.rw",
        "sfcc.shopper-myaccount.rw",
        "sfcc.shopper-product-search",
        "sfcc.shopper-productlists",
        "sfcc.shopper-products",
        "sfcc.shopper-promotions",
        "sfcc.ta_ext_on_behalf_of",
        "sfcc.ts_ext_on_behalf_of"
    ],
    "redirectUri": [
        "http://127.0.0.1:3000/callback",
        "http://localhost:3000/callback",
        "https://*.mobify-storefront.com/callback"
    ]
}'
```

## OCAPI Settings for SLAS Clients (Facebook & Instagram Only)

In the order integration between Facebook/Instagram and SFCC, the SLAS client will use some OCAPI calls, and because of that, some permissions should be granted to the SLAS client in the ***OCAPI Settings*** configuration:

1. Log into the Business Manager
2. Navigate to ***Administration > Site Development > Open Commerce API Settings***
3. Make sure that `Shop API` and `Global` are selected from the `Select Type` and `Select Context` boxes
4. Add the permission set for your Account Manager API Client ID to the settings
5. Use the following snippet as your client's permission set, replace `my_client_id` with your own SLAS Client ID

```JSON
    {
      "_v": "19.5",
      "clients":
      [
        {
          "client_id": "my_client_id",
          "resources": [
            {
              "resource_id": "/order_search",
              "methods": [
                "post"
              ],
              "read_attributes": "(**)",
              "write_attributes": "(**)"
            },
            {
              "resource_id": "/orders/*",
              "methods": [
                "get",
                "patch"
              ],
              "read_attributes": "(**)",
              "write_attributes": "(**)"
            }
          ]
        }
      ]
    }
```

:pushpin: Note, if you already have ***Open Commerce API Settings*** configured on your instance, e.g. for other API keys, you have to merge this permission set into the existing list of permission sets of the other clients.

## Additional Information
You can find examples of using the SLAS private client ID and secret to get a `ShopperTokenTsob` (TSOB = trusted system on behalf) in the repo [postman collection](./postman).